/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import jp.sfjp.armadillo.archive.ArchiveType;
import jp.sfjp.armadillo.archive.cab.DumpCabHeader;
import jp.sfjp.armadillo.archive.lzh.DumpLzhHeader;
import jp.sfjp.armadillo.archive.tar.DumpTarHeader;
import jp.sfjp.armadillo.archive.zip.DumpZipHeader;

public abstract class DumpArchiveHeader {
    public abstract void dump(InputStream var1, PrintWriter var2) throws IOException;

    protected void printOffset(PrintWriter printWriter, long l) {
        printWriter.printf("%n---------- offset %1$d ( 0x%1$08X )%n", l);
    }

    protected void printEnd(PrintWriter printWriter, String string, long l) {
        printWriter.printf("%n---------- end of %1$s : position = %2$d ( 0x%2$08X )%n", string, l);
    }

    protected void printHeaderName(PrintWriter printWriter, String string) {
        printWriter.printf("%n%s%n", string);
    }

    protected static void warn(PrintWriter printWriter, String string, Object ... objectArray) {
        printWriter.printf("warn: " + string + "%n", objectArray);
    }

    public static DumpArchiveHeader getInstance(String string) {
        switch (ArchiveType.of(string)) {
            case CAB: {
                return new DumpCabHeader();
            }
            case LZH: {
                return new DumpLzhHeader();
            }
            case TAR: {
                return new DumpTarHeader();
            }
            case ZIP: {
                return new DumpZipHeader();
            }
        }
        throw new IllegalArgumentException("unknown type: " + string);
    }

    public static void execute(File file) throws IOException {
        DumpArchiveHeader.execute(file, new PrintWriter(System.out, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(File file, PrintWriter printWriter) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            DumpArchiveHeader.getInstance(file.getName()).dump(fileInputStream, printWriter);
        }
        finally {
            fileInputStream.close();
        }
    }

    public static void main(String ... stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.out.println("usage: DumpArchiveHeader file [ file2 ... fileN ]");
            return;
        }
        for (String string : stringArray) {
            File file = new File(string);
            if (!file.exists()) {
                System.out.printf("warn: file [%s] not found %n", string);
                continue;
            }
            try {
                DumpArchiveHeader.execute(file);
            }
            catch (Exception exception) {
                System.err.printf("%n--- at file [%s]%n", file.getAbsolutePath());
                exception.printStackTrace();
            }
        }
    }
}

