/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import jp.sfjp.armadillo.archive.cab.CabCompressionType;

public final class CabCfData
extends FilterOutputStream {
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    OutputStream os = this.bos;
    private Deflater deflater;
    int uncompsize = 0;
    boolean finished;
    private final CabCompressionType type;

    public CabCfData(CabCompressionType cabCompressionType) {
        super(null);
        this.type = cabCompressionType;
        switch (cabCompressionType) {
            case No: {
                this.os = this.bos;
                break;
            }
            case MSZIP: {
                this.bos.write(67);
                this.bos.write(75);
                this.deflater = new Deflater(9, true);
                this.deflater.reset();
                this.os = new DeflaterOutputStream((OutputStream)this.bos, this.deflater);
                break;
            }
            case Quantum: 
            case LZX: 
            case Unknown: {
                throw new UnsupportedOperationException("comptype: " + (Object)((Object)cabCompressionType));
            }
        }
    }

    @Override
    public void write(int n) throws IOException {
        if (this.finished) {
            throw new IOException("stream closed");
        }
        this.os.write(n);
        ++this.uncompsize;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        switch (this.type) {
            case MSZIP: {
                if (!(this.os instanceof DeflaterOutputStream)) break;
                DeflaterOutputStream deflaterOutputStream = (DeflaterOutputStream)this.os;
                deflaterOutputStream.finish();
                deflaterOutputStream.flush();
                break;
            }
            case No: {
                this.os.flush();
                break;
            }
        }
        this.os = this.bos;
        this.finished = true;
    }

    public void writeInto(OutputStream outputStream) throws IOException {
        if (!this.finished) {
            throw new IOException("stream is not closed yet");
        }
        this.bos.writeTo(outputStream);
    }
}

