/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.util.zip.Checksum;

public final class CabChecksum
implements Checksum {
    private final int seed;
    private int value;
    private int p;
    private int tmp;

    public CabChecksum() {
        this(0);
    }

    public CabChecksum(int n) {
        this.seed = n;
        this.reset();
    }

    @Override
    public void update(int n) {
        switch (++this.p % 4) {
            case 0: {
                this.tmp = n;
                break;
            }
            case 1: {
                this.tmp |= n << 8;
                break;
            }
            case 2: {
                this.tmp |= n << 16;
                break;
            }
            case 3: {
                this.tmp |= n << 24;
                this.value ^= this.tmp;
                this.tmp = 0;
                break;
            }
        }
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.update(byArray[i] & 0xFF);
        }
    }

    @Override
    public long getValue() {
        int n;
        int n2 = (this.p + 1) % 4;
        if (n2 == 0) {
            n = this.value;
        } else {
            int n3 = 0;
            switch (n2) {
                case 3: {
                    n3 |= this.tmp << 16 & 0xFF0000;
                    n3 |= this.tmp & 0xFF00;
                    assert ((n3 |= this.tmp >> 16 & 0xFF) == (n3 & 0xFFFFFF));
                    break;
                }
                case 2: {
                    n3 |= this.tmp << 8 & 0xFF00;
                    assert ((n3 |= this.tmp >> 8 & 0xFF) == (n3 & 0xFFFF));
                    break;
                }
                case 1: {
                    n3 = this.tmp;
                    assert (n3 == (n3 & 0xFF));
                    break;
                }
            }
            n = this.value ^ n3;
        }
        assert (n == (n & 0xFFFFFFFF));
        return n;
    }

    @Override
    public void reset() {
        this.value = this.seed;
        this.p = -1;
    }
}

