/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.cab;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import jp.sfjp.armadillo.archive.cab.CabCfData;
import jp.sfjp.armadillo.archive.cab.CabCfFile;
import jp.sfjp.armadillo.archive.cab.CabCfFolder;
import jp.sfjp.armadillo.archive.cab.CabChecksum;
import jp.sfjp.armadillo.archive.cab.CabEntry;
import jp.sfjp.armadillo.archive.cab.CabException;

public final class CabHeader {
    static final int SIGNATURE = 1297302342;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 3;
    private final ByteBuffer buffer = ByteBuffer.allocate(8192);
    private boolean initialized = false;
    private final List<CabCfFile> fileEntriesOnRead = new ArrayList<CabCfFile>();
    private int entryIndex;
    private short[] folderCompressType;

    public boolean initialize(InputStream inputStream) throws IOException {
        if (this.initialized) {
            return false;
        }
        try {
            this.readFileHeader(inputStream);
            return true;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CabException("readFileHeader", arrayIndexOutOfBoundsException);
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            throw new CabException("readFileHeader", bufferUnderflowException);
        }
    }

    private void readFileHeader(InputStream inputStream) throws IOException {
        short s;
        int n;
        int n2;
        int n3;
        this.buffer.clear();
        this.buffer.limit(36);
        Channels.newChannel(inputStream).read(this.buffer);
        if (this.buffer.position() == 0) {
            throw new CabException("reading archive header, but position is zero");
        }
        this.buffer.rewind();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int n4 = this.buffer.getInt();
        if (n4 != 1297302342) {
            throw new CabException("bad signature: 0x%X", n4);
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int n5 = this.buffer.getInt();
        int n6 = this.buffer.getInt();
        int n7 = this.buffer.getInt();
        int n8 = this.buffer.getInt();
        int n9 = this.buffer.getInt();
        byte by = this.buffer.get();
        byte by2 = this.buffer.get();
        int n10 = this.buffer.getShort();
        int n11 = this.buffer.getShort();
        short s2 = this.buffer.getShort();
        short s3 = this.buffer.getShort();
        short s4 = this.buffer.getShort();
        if (s4 != 0) {
            throw new CabException("iCabinet not supported: 0x%d", s4);
        }
        this.folderCompressType = new short[n10];
        for (n3 = 0; n3 < n10; ++n3) {
            this.buffer.clear();
            this.buffer.limit(8);
            Channels.newChannel(inputStream).read(this.buffer);
            if (this.buffer.position() == 0) {
                throw new CabException("reading CFFOLDER header, but position is zero");
            }
            this.buffer.rewind();
            n2 = this.buffer.getInt();
            n = this.buffer.getShort();
            s = this.buffer.getShort();
            byte[] byArray = new byte[]{};
            this.folderCompressType[n3] = s;
        }
        for (n3 = 0; n3 < n11; ++n3) {
            this.buffer.clear();
            this.buffer.limit(16);
            Channels.newChannel(inputStream).read(this.buffer);
            if (this.buffer.position() == 0) {
                throw new CabException("reading CFFILE header, but position is zero");
            }
            this.buffer.rewind();
            n2 = this.buffer.getInt();
            n = this.buffer.getInt();
            s = this.buffer.getShort();
            short s5 = this.buffer.getShort();
            short s6 = this.buffer.getShort();
            short s7 = this.buffer.getShort();
            byte[] byArray = this.readName(inputStream, 256);
            CabCfFile cabCfFile = new CabCfFile(byArray);
            cabCfFile.uncompressedSize = n2;
            cabCfFile.uncompressedOffset = n;
            cabCfFile.folderIndex = s;
            cabCfFile.date = s5;
            cabCfFile.time = s6;
            cabCfFile.attributes = s7;
            cabCfFile.setName(byArray);
            this.fileEntriesOnRead.add(cabCfFile);
        }
        this.initialized = true;
    }

    private byte[] readName(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (int i = 0; i < n && (n2 = inputStream.read()) > 0; ++i) {
            byArray[i] = (byte)(n2 & 0xFF);
            ++n3;
        }
        if (n3 < n) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }

    public CabEntry read(InputStream inputStream) throws IOException {
        if (!this.initialized) {
            this.initialize(inputStream);
        }
        if (this.entryIndex >= this.fileEntriesOnRead.size()) {
            return null;
        }
        return this.fileEntriesOnRead.get(this.entryIndex++);
    }

    public void write(OutputStream outputStream, List<CabCfFolder> list) throws IOException {
        short s;
        int n;
        ArrayList<CabCfFile> arrayList = new ArrayList<CabCfFile>();
        for (CabCfFolder cabCfFolder : list) {
            arrayList.addAll(cabCfFolder.files);
        }
        assert (list.size() <= Short.MAX_VALUE);
        assert (arrayList.size() <= Short.MAX_VALUE);
        int n2 = 1297302342;
        int n3 = 0;
        int n4 = CabHeader.calculateFileSize(list, arrayList);
        int n5 = 0;
        int n6 = 0;
        int n7 = CabHeader.calculateOffsetOfFirstCffile(list);
        byte by = 3;
        byte by2 = 1;
        short s3 = (short)list.size();
        short s4 = (short)arrayList.size();
        short s5 = 0;
        short s6 = 0;
        short s7 = 0;
        this.buffer.clear();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer.putInt(1297302342);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(n3);
        this.buffer.putInt(n4);
        this.buffer.putInt(n5);
        this.buffer.putInt(n7);
        this.buffer.putInt(n6);
        this.buffer.put(by);
        this.buffer.put(by2);
        this.buffer.putShort(s3);
        this.buffer.putShort(s4);
        this.buffer.putShort(s5);
        this.buffer.putShort(s6);
        this.buffer.putShort(s7);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
        int n8 = CabHeader.calculateOffsetOfCabStart(list);
        for (CabCfFolder cabEntry : list) {
            assert (cabEntry.arrayOfCfData.size() <= Short.MAX_VALUE);
            n = n8;
            short s2 = (short)cabEntry.arrayOfCfData.size();
            s = cabEntry.method;
            this.buffer.clear();
            this.buffer.putInt(n);
            this.buffer.putShort(s2);
            this.buffer.putShort(s);
            this.buffer.flip();
            Channels.newChannel(outputStream).write(this.buffer);
            n8 += cabEntry.getCompressedDataSize();
        }
        for (CabCfFile cabCfFile : arrayList) {
            n = cabCfFile.uncompressedSize;
            int n9 = cabCfFile.uncompressedOffset;
            s = cabCfFile.folderIndex;
            short s8 = cabCfFile.date;
            short s9 = cabCfFile.time;
            short s10 = cabCfFile.attributes;
            byte[] byArray = cabCfFile.getNameAsBytes();
            this.buffer.clear();
            this.buffer.putInt(n);
            this.buffer.putInt(n9);
            this.buffer.putShort(s);
            this.buffer.putShort(s8);
            this.buffer.putShort(s9);
            this.buffer.putShort(s10);
            this.buffer.put(byArray);
            this.buffer.put((byte)0);
            this.buffer.flip();
            Channels.newChannel(outputStream).write(this.buffer);
        }
    }

    public void writeCfDataHeader(OutputStream outputStream, CabCfData cabCfData) throws IOException {
        if (!cabCfData.finished) {
            throw new IOException("stream is not closed yet");
        }
        assert (cabCfData.uncompsize >= 0 && cabCfData.uncompsize <= 32768);
        byte[] byArray = cabCfData.bos.toByteArray();
        short s = (short)(byArray.length & 0xFFFF);
        short s2 = cabCfData.uncompsize == 32768 ? (short)Short.MIN_VALUE : (short)cabCfData.uncompsize;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.clear();
        int n = this.calcucateChecksum(byArray, s, s2);
        short s3 = s;
        short s4 = s2;
        this.buffer.putInt(n);
        this.buffer.putShort(s3);
        this.buffer.putShort(s4);
        this.buffer.flip();
        Channels.newChannel(outputStream).write(this.buffer);
    }

    private int calcucateChecksum(byte[] byArray, short s, short s2) {
        int n = CabHeader.calcucateChecksum0(byArray, s, 0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(s);
        byteBuffer.putShort(s2);
        byteBuffer.rewind();
        byte[] byArray2 = new byte[4];
        byteBuffer.get(byArray2);
        return CabHeader.calcucateChecksum0(byArray2, 4, n);
    }

    private static int calcucateChecksum0(byte[] byArray, int n, int n2) {
        CabChecksum cabChecksum = new CabChecksum(n2);
        cabChecksum.update(byArray, 0, n);
        return (int)(cabChecksum.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    static int calculateFileSize(List<CabCfFolder> list, List<CabCfFile> list2) {
        int n = 0;
        n += 36;
        n += list.size() * 8;
        for (CabCfFile cabEntry : list2) {
            n += 16 + cabEntry.getName().getBytes().length + 1;
        }
        for (CabCfFolder cabCfFolder : list) {
            n += cabCfFolder.getCompressedDataSize() + 8;
        }
        return n;
    }

    static int calculateOffsetOfFirstCffile(List<CabCfFolder> list) {
        return 36 + list.size() * 8;
    }

    static int calculateOffsetOfCabStart(List<CabCfFolder> list) {
        int n = 0;
        n += CabHeader.calculateOffsetOfFirstCffile(list);
        for (CabCfFolder cabCfFolder : list) {
            for (CabCfFile cabCfFile : cabCfFolder.files) {
                n += 16 + cabCfFile.getName().getBytes().length + 1;
            }
        }
        return n;
    }
}

