/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.tar.TarEntry;
import jp.sfjp.armadillo.archive.tar.TarOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class TarArchiveCreator
implements ArchiveCreator {
    private final TarOutputStream os;

    public TarArchiveCreator(OutputStream outputStream) {
        this.os = new TarOutputStream(outputStream);
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        return new TarEntry(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            this.os.putNextEntry(TarArchiveCreator.toTarEntry(archiveEntry));
            this.os.closeEntry();
        } else {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.addEntry(archiveEntry, fileInputStream, file.length());
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        archiveEntry.setAdded(true);
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        TarEntry tarEntry = TarArchiveCreator.toTarEntry(archiveEntry);
        tarEntry.setSize(l);
        this.os.putNextEntry(tarEntry);
        long l2 = IOUtilities.transferAll(inputStream, this.os);
        this.os.closeEntry();
        assert (l2 == tarEntry.getSize()) : "file size";
        assert (l2 == l) : "file size";
        archiveEntry.setSize(l2);
        archiveEntry.setAdded(true);
    }

    static TarEntry toTarEntry(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof TarEntry) {
            return (TarEntry)archiveEntry;
        }
        TarEntry tarEntry = new TarEntry(archiveEntry.getName());
        archiveEntry.copyTo(tarEntry);
        return tarEntry;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

