/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.tar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import jp.sfjp.armadillo.archive.tar.TarEntry;
import jp.sfjp.armadillo.archive.tar.TarException;

public final class TarHeader {
    static final int BLOCK_SIZE = 512;
    private static final String MAGIC_USTAR = "ustar";
    private final byte[] buffer = new byte[512];
    private int position = 0;

    public TarEntry read(InputStream inputStream) throws IOException {
        this.reset();
        int n = TarHeader.draw(inputStream, this.buffer);
        if (n == 0) {
            return null;
        }
        if (n != 512) {
            throw new TarException("bad header: size=" + n);
        }
        if (this.buffer[0] == 0 && this.isEmptyBlock()) {
            if (inputStream.read(this.buffer) == 512 && this.isEmptyBlock()) {
                return null;
            }
            throw new TarException("bad end-of-archive");
        }
        try {
            if (this.isUstar()) {
                return this.readUstar(inputStream);
            }
            return this.readTar(inputStream);
        }
        catch (RuntimeException runtimeException) {
            throw new TarException("bad header at " + this.position, runtimeException);
        }
    }

    private boolean isUstar() {
        String string = new String(this.buffer, 257, 5);
        return string.equals(MAGIC_USTAR);
    }

    private TarEntry readTar(InputStream inputStream) throws IOException {
        byte[] byArray = this.clipNameField(100);
        int n = this.clipAsInt(8);
        int n2 = this.clipAsInt(8);
        int n3 = this.clipAsInt(8);
        long l = this.clipAsLong(12);
        long l2 = this.clipAsLong(12);
        int n4 = this.clipAsInt(8);
        int n5 = this.clipAsInt(1);
        String string = this.clipAsString(100);
        TarEntry tarEntry = new TarEntry();
        tarEntry.setName(byArray);
        tarEntry.setMode(n);
        tarEntry.uid = n2;
        tarEntry.gid = n3;
        tarEntry.size = l;
        tarEntry.mtime = l2;
        tarEntry.chksum = n4;
        tarEntry.linkname = string;
        return tarEntry;
    }

    private TarEntry readUstar(InputStream inputStream) throws IOException {
        TarEntry tarEntry = new TarEntry();
        this.readUstar(inputStream, tarEntry);
        if (tarEntry.typeflag == 'L') {
            int n = TarHeader.draw(inputStream, this.buffer);
            assert (n == 512);
            assert (tarEntry.size <= Integer.MAX_VALUE);
            this.position = 0;
            byte[] byArray = this.clipNameField((int)tarEntry.size);
            this.position = 0;
            int n2 = TarHeader.draw(inputStream, this.buffer);
            assert (n2 == 512);
            this.readUstar(inputStream, tarEntry);
            tarEntry.setName(byArray);
        }
        return tarEntry;
    }

    private void readUstar(InputStream inputStream, TarEntry tarEntry) throws IOException {
        byte[] byArray = this.clipNameField(100);
        int n = this.clipAsInt(8);
        int n2 = this.clipAsInt(8);
        int n3 = this.clipAsInt(8);
        long l = this.clipAsLong(12);
        long l2 = this.clipAsLong(12);
        int n4 = this.clipAsInt(8);
        char c = this.clipChar();
        String string = this.clipAsString(100);
        String string2 = this.clipAsString(6);
        String string3 = this.clipAsString(2);
        String string4 = this.clipAsString(32);
        String string5 = this.clipAsString(32);
        String string6 = this.clipAsString(8);
        String string7 = this.clipAsString(8);
        String string8 = this.clipAsString(155);
        tarEntry.setName(byArray);
        tarEntry.setMode(n);
        tarEntry.uid = n2;
        tarEntry.gid = n3;
        tarEntry.size = l;
        tarEntry.mtime = l2;
        tarEntry.chksum = n4;
        tarEntry.typeflag = c;
        tarEntry.linkname = string;
        tarEntry.magic = string2;
        tarEntry.version = string3;
        tarEntry.uname = string4;
        tarEntry.gname = string5;
        tarEntry.devmajor = string6;
        tarEntry.devminor = string7;
        tarEntry.prefix = string8;
    }

    private char clipChar() {
        String string = this.clipAsString(1);
        if (string.isEmpty()) {
            return ' ';
        }
        return string.charAt(0);
    }

    private static int draw(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        for (n = 0; n < 512 && (n2 = inputStream.read(byArray, n3, 512 - n)) > 0; n += n2) {
            n3 += n2;
        }
        return n;
    }

    public void write(OutputStream outputStream, TarEntry tarEntry) throws IOException {
        try {
            this.reset();
            if (tarEntry.magic.startsWith(MAGIC_USTAR)) {
                this.writeUstar(outputStream, tarEntry);
            } else {
                this.writeTar(outputStream, tarEntry);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new TarException("bad header at " + this.position, runtimeException);
        }
    }

    private void writeTar(OutputStream outputStream, TarEntry tarEntry) throws IOException {
        String string = tarEntry.name();
        int n = tarEntry.getMode();
        int n2 = tarEntry.uid;
        int n3 = tarEntry.gid;
        long l = tarEntry.size;
        long l2 = tarEntry.mtime;
        int n4 = tarEntry.chksum;
        int n5 = 0;
        String string2 = tarEntry.linkname;
        this.patch(100, string);
        this.patch(8, n);
        this.patch(8, n2);
        this.patch(8, n3);
        this.patch(12, l);
        this.patch(12, l2);
        this.patch(8, n4);
        this.patch(1, n5);
        this.patch(100, string2);
        outputStream.write(this.buffer);
        throw new TarException("not impl yet (old Tar)");
    }

    private void writeUstar(OutputStream outputStream, TarEntry tarEntry) throws IOException {
        String string = tarEntry.name();
        int n = tarEntry.getMode();
        int n2 = tarEntry.uid;
        int n3 = tarEntry.gid;
        long l = tarEntry.size;
        long l2 = tarEntry.mtime;
        int n4 = tarEntry.chksum;
        char c = tarEntry.typeflag;
        String string2 = tarEntry.linkname;
        String string3 = tarEntry.magic;
        String string4 = tarEntry.version;
        String string5 = tarEntry.uname;
        String string6 = tarEntry.gname;
        String string7 = tarEntry.devmajor;
        String string8 = tarEntry.devminor;
        String string9 = tarEntry.prefix;
        this.patch(100, string);
        this.patch(8, n);
        this.patch(8, n2);
        this.patch(8, n3);
        this.patch(12, l);
        this.patch(12, l2);
        this.patch(8, "        ");
        this.patch(1, c);
        this.patch(100, string2);
        this.patch(6, "ustar ");
        this.patch(2, string4);
        this.patch(32, string5);
        this.patch(32, string6);
        this.patch(8, string7);
        this.patch(8, string8);
        this.patch(155, string9);
        int n5 = 0;
        for (int i = 0; i < this.buffer.length; ++i) {
            n5 += this.buffer[i] & 0xFF;
        }
        this.position = 148;
        this.patch(6, n5);
        tarEntry.chksum = n5;
        outputStream.write(this.buffer);
    }

    public void writeEndOfArchive(OutputStream outputStream) throws IOException {
        this.reset();
        outputStream.write(this.buffer);
        outputStream.write(this.buffer);
        outputStream.flush();
    }

    public void reset() {
        this.position = 0;
        Arrays.fill(this.buffer, (byte)0);
    }

    private byte[] clipNameField(int n) {
        assert (n <= 512 - this.position);
        int n2 = this.position;
        this.position += n;
        int n3 = 0;
        for (int i = 0; i < n && this.buffer[n2 + i] != 0; ++i) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buffer, 0, byArray, 0, n3);
        return byArray;
    }

    private String clipAsString(int n) {
        assert (n <= 512 - this.position);
        int n2 = this.position;
        this.position += n;
        int n3 = 0;
        for (int i = 0; i < n && this.buffer[n2 + i] != 0; ++i) {
            ++n3;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n3; ++i) {
            byte by = this.buffer[n2 + i];
            if (by < 32 || by > 127) {
                stringBuilder.append(String.format("\\%o", by & 0xFF));
                continue;
            }
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    private int clipAsInt(int n) {
        String string = this.clipAsNumberString(n);
        return string.isEmpty() ? 0 : Integer.parseInt(string, 8);
    }

    private long clipAsLong(int n) {
        String string = this.clipAsNumberString(n);
        return string.isEmpty() ? 0L : Long.parseLong(string, 8);
    }

    private String clipAsNumberString(int n) {
        byte by;
        int n2;
        assert (n <= 512 - this.position);
        int n3 = this.position;
        this.position += n;
        for (n2 = 0; n2 < n && (by = this.buffer[n3 + n2]) != 0; ++n2) {
            boolean bl;
            assert (by == 32 || by >= 48 && by <= 57);
            boolean bl2 = bl = by == 32 || by >= 48 && by <= 57;
            if (bl) continue;
            System.out.print("");
        }
        return new String(this.buffer, n3, n2).trim();
    }

    private int patch(int n, String string) {
        int n2 = this.position;
        this.position += n;
        byte[] byArray = string == null || string.isEmpty() ? new byte[]{} : string.getBytes();
        int n3 = byArray.length > n ? n : byArray.length;
        System.arraycopy(byArray, 0, this.buffer, n2, n3);
        return byArray.length;
    }

    private int patch(int n, int n2) {
        String string = this.padZero(Integer.toOctalString(n2), n - 1);
        return this.patch(n, string);
    }

    private int patch(int n, long l) {
        String string = this.padZero(Long.toOctalString(l), n - 1);
        return this.patch(n, string);
    }

    private String padZero(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 >= n) {
            return string;
        }
        char[] cArray = new char[n];
        int n4 = n - n3;
        for (n2 = 0; n2 < n4; ++n2) {
            cArray[n2] = 48;
        }
        for (n2 = n4; n2 < n; ++n2) {
            cArray[n2] = string.charAt(n2 - n4);
        }
        return String.valueOf(cArray);
    }

    private boolean isEmptyBlock() {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    static long getSkipSize(long l) {
        if (l == 0L || l == 512L || l % 512L == 0L) {
            return 0L;
        }
        return 512L - (l > 512L ? l % 512L : l);
    }
}

