/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jp.sfjp.armadillo.archive.ArchiveCreator;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.archive.zip.ZipOutputStream;
import jp.sfjp.armadillo.io.IOUtilities;

public final class ZipArchiveCreator
implements ArchiveCreator {
    private ZipOutputStream os;

    public ZipArchiveCreator(OutputStream outputStream) {
        this.os = new ZipOutputStream(outputStream);
    }

    @Override
    public ArchiveEntry newEntry(String string) {
        return new ZipEntry(string);
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, File file) throws IOException {
        if (file.isDirectory()) {
            this.os.putNextEntry(ZipArchiveCreator.toZipEntry(archiveEntry));
            this.os.closeEntry();
            archiveEntry.setAdded(true);
        } else {
            this.addEntry(archiveEntry, file, null, file.length());
        }
    }

    @Override
    public void addEntry(ArchiveEntry archiveEntry, InputStream inputStream, long l) throws IOException {
        this.addEntry(archiveEntry, null, inputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEntry(ArchiveEntry archiveEntry, File file, InputStream inputStream, long l) throws IOException {
        ZipEntry zipEntry = ZipArchiveCreator.toZipEntry(archiveEntry);
        zipEntry.setSize(l);
        if (l == 0L) {
            zipEntry.setCompressedSize(0L);
            zipEntry.method = 0;
        }
        this.os.putNextEntry(zipEntry);
        if (l > 0L) {
            long l2;
            InputStream inputStream2 = inputStream == null ? new FileInputStream(file) : inputStream;
            try {
                l2 = IOUtilities.transfer(inputStream2, this.os, l);
            }
            finally {
                if (inputStream == null) {
                    inputStream2.close();
                }
            }
            assert (l2 == zipEntry.getSize()) : "file size";
            assert (l2 == l) : "file size";
            archiveEntry.setSize(l2);
        }
        this.os.closeEntry();
        archiveEntry.setAdded(true);
    }

    static ZipEntry toZipEntry(ArchiveEntry archiveEntry) {
        if (archiveEntry instanceof ZipEntry) {
            return (ZipEntry)archiveEntry;
        }
        ZipEntry zipEntry = new ZipEntry(archiveEntry.getName());
        archiveEntry.copyTo(zipEntry);
        if (zipEntry.isDirectory()) {
            zipEntry.method = 0;
        }
        return zipEntry;
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }
}

