/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.IOException;
import java.util.List;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.archive.zip.ZipHeader;
import jp.sfjp.armadillo.io.VolumetricOutputStream;

final class ZipEndEntry {
    int signature;
    short disknum;
    short disknumCEN;
    short countDiskCENs;
    short countCENs;
    int sizeCENs;
    int offsetStartCEN;
    short commentlen;
    byte[] comment;

    ZipEndEntry() {
    }

    static ZipEndEntry create(long l, List<ZipEntry> list) throws IOException {
        int n = list.size();
        if (n > 65535) {
            throw new ZipException("overflow: entry-count=" + n);
        }
        short s = (short)(n & 0xFFFF);
        if (l > 0xFFFFFFFFL) {
            throw new ZipException("overflow: offset=" + l);
        }
        assert (l >= 0L);
        long l2 = l;
        ZipHeader zipHeader = new ZipHeader();
        VolumetricOutputStream volumetricOutputStream = new VolumetricOutputStream();
        for (ZipEntry zipEntry : list) {
            zipHeader.writeCEN(volumetricOutputStream, zipEntry);
        }
        long l3 = volumetricOutputStream.getSize();
        if (l3 > 0xFFFFFFFFL) {
            throw new ZipException("overflow: size of CEN headers=" + l3);
        }
        int n2 = 101010256;
        short s2 = 0;
        short s3 = 0;
        short s4 = s;
        short s5 = s;
        int n3 = (int)(l3 & 0xFFFFFFFFL);
        int n4 = (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
        short s6 = 0;
        byte[] byArray = new byte[]{};
        ZipEndEntry zipEndEntry = new ZipEndEntry();
        zipEndEntry.signature = n2;
        zipEndEntry.disknum = s2;
        zipEndEntry.disknumCEN = s3;
        zipEndEntry.countDiskCENs = s4;
        zipEndEntry.countCENs = s5;
        zipEndEntry.sizeCENs = n3;
        zipEndEntry.offsetStartCEN = n4;
        zipEndEntry.commentlen = s6;
        zipEndEntry.comment = byArray;
        return zipEndEntry;
    }
}

