/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.File;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.time.FTime;

public final class ZipEntry
extends ArchiveEntry {
    public static final short STORED = 0;
    public static final short DEFLATED = 8;
    private static final long UINT_MAX = 0xFFFFFFFFL;
    private static final long USHORT_MAX = 65535L;
    private static final FTime FTIME = new FTime();
    boolean extOverwritten;
    int reloff;
    int signature;
    short version = (short)10;
    short flags = 0;
    short method = (short)8;
    short mtime = 0;
    short mdate = 0;
    int crc = -1;
    int compsize = 0;
    int uncompsize = 0;
    short extlen;

    public ZipEntry() {
        super(false);
    }

    public ZipEntry(String string) {
        this();
        this.setName(string);
    }

    public ZipEntry(String string, File file) {
        this(string);
        this.setFileInfo(file);
    }

    public boolean hasEXT() {
        return (this.flags & 8) == 8;
    }

    public boolean isOnePassMode() {
        return this.crc == -1;
    }

    @Override
    public long getSize() {
        if (this.isDirectory()) {
            return 0L;
        }
        return (long)this.uncompsize & 0xFFFFFFFFL;
    }

    @Override
    public void setSize(long l) {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("max size is int.max: " + l);
        }
        this.uncompsize = (int)(l & 0xFFFFFFFFL);
    }

    @Override
    public long getCompressedSize() {
        if (this.isDirectory()) {
            return 0L;
        }
        return (long)this.compsize & 0xFFFFFFFFL;
    }

    @Override
    public void setCompressedSize(long l) {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("max size is int-max: " + l);
        }
        this.compsize = (int)(l & 0xFFFFFFFFL);
    }

    @Override
    public long getLastModified() {
        return FTIME.toMillisecond(this.mdate, this.mtime);
    }

    @Override
    public void setLastModified(long l) {
        int n = FTIME.int32From(l);
        this.mdate = (short)((long)(n >> 16) & 0xFFFFL);
        this.mtime = (short)((long)n & 0xFFFFL);
    }

    @Override
    public String getMethodName() {
        return ZipEntry.getMethodName(this.method);
    }

    private static String getMethodName(int n) {
        switch (n) {
            case 8: {
                return "DEFLATED";
            }
            case 0: {
                return "STORED";
            }
        }
        return String.valueOf(n);
    }
}

