/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.ArchiveInputStream;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.archive.zip.ZipHeader;
import jp.sfjp.armadillo.io.RewindableInputStream;

public final class ZipInputStream
extends ArchiveInputStream {
    private static final int BUFFER_SIZE = 16384;
    private ZipHeader header = new ZipHeader();
    private ZipEntry ongoingEntry;
    private Inflater inflater = new Inflater(true);

    public ZipInputStream(InputStream inputStream) {
        super(new RewindableInputStream(inputStream, 16384));
    }

    public ZipEntry getNextEntry() throws IOException {
        ZipEntry zipEntry;
        this.ensureOpen();
        if (this.ongoingEntry != null) {
            this.closeEntry();
        }
        if ((zipEntry = this.header.readLOC(this.in)) == null) {
            return null;
        }
        return this.openEntry(zipEntry);
    }

    ZipEntry openEntry(ZipEntry zipEntry) throws IOException {
        assert (zipEntry != null);
        if (zipEntry.isDirectory() || zipEntry.method == 0) {
            this.frontStream = this.in;
        } else if (zipEntry.method == 8) {
            this.frontStream = new InflaterInputStream(this.in, this.inflater, 512);
        } else {
            System.out.printf("method=%d, name=%s%n", zipEntry.method, zipEntry.getName());
            this.frontStream = this.in;
        }
        if (zipEntry.hasEXT()) {
            if (zipEntry.isDirectory() && !this.header.readEXT(this.in, zipEntry)) {
                throw new ZipException("failed to read EXT header on stream mode (0)");
            }
            byte[] byArray = new byte[16384];
            int n = this.in.read(byArray);
            int n2 = ZipInputStream.findSIGEXT(byArray);
            if (n2 < 0) {
                throw new ZipException("failed to read EXT header on stream mode (1)");
            }
            ((RewindableInputStream)this.in).rewind(n);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n2, 16);
            if (!this.header.readEXT(byteArrayInputStream, zipEntry)) {
                throw new ZipException("failed to read EXT header on stream mode (2)");
            }
        }
        this.remaining = zipEntry.getSize();
        this.ongoingEntry = zipEntry;
        return this.ongoingEntry;
    }

    public void closeEntry() throws IOException {
        ZipEntry zipEntry = this.ongoingEntry;
        this.ensureOpen();
        if (!zipEntry.isDirectory()) {
            int n;
            if (this.remaining > 0L) {
                long l = zipEntry.compsize;
                long l2 = zipEntry.uncompsize;
                if (this.remaining == l2) {
                    long l3;
                    for (l3 = l; l3 > 0L; l3 -= this.in.skip(l3)) {
                    }
                    this.remaining -= l2;
                    assert (l3 != 0L) : "skipped size should be zero, but was " + l3;
                }
            }
            if ((n = this.inflater.getRemaining()) > 0) {
                ((RewindableInputStream)this.in).rewind(n);
            }
            assert (this.remaining == 0L) : "remaining should be zero, but was %d" + this.remaining;
            if (zipEntry.hasEXT() && !this.header.readEXT(this.in, zipEntry)) {
                throw new ZipException("failed to read EXT header on stream mode (3)");
            }
        }
        this.ongoingEntry = null;
        this.inflater.reset();
        this.frontStream = this.in;
    }

    private static int findSIGEXT(byte[] byArray) {
        for (int i = 0; i < byArray.length - 3; ++i) {
            if (byArray[i] != 80 || byArray[i + 1] != 75 || byArray[i + 2] != 7 || byArray[i + 3] != 8) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.header = null;
        this.inflater = null;
        this.ongoingEntry = null;
    }
}

