/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.archive.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipException;
import jp.sfjp.armadillo.archive.ArchiveOutputStream;
import jp.sfjp.armadillo.archive.zip.ZipEntry;
import jp.sfjp.armadillo.archive.zip.ZipHeader;

public final class ZipOutputStream
extends ArchiveOutputStream {
    private ZipHeader header = new ZipHeader();
    private Deflater deflater = new Deflater(-1, true);
    private CRC32 crc = new CRC32();
    private ZipEntry ongoingEntry;

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.frontStream = outputStream;
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.ensureOpen();
        if (this.ongoingEntry != null) {
            this.closeEntry();
        }
        assert (zipEntry.method != -1);
        assert (zipEntry.uncompsize >= 0);
        if (zipEntry.isDirectory()) {
            zipEntry.version = (short)10;
            zipEntry.flags = (short)(zipEntry.flags & 0xFFF7);
            zipEntry.compsize = 0;
            zipEntry.uncompsize = 0;
            zipEntry.crc = 0;
        } else if (zipEntry.method == 0) {
            int n = zipEntry.uncompsize >= 0 ? zipEntry.uncompsize : zipEntry.compsize;
            zipEntry.version = (short)10;
            zipEntry.compsize = n;
            zipEntry.uncompsize = n;
        } else if (zipEntry.method == 8) {
            zipEntry.version = (short)20;
            if (zipEntry.isOnePassMode()) {
                zipEntry.flags = (short)(zipEntry.flags | 8);
            }
            if (!zipEntry.isDirectory()) {
                this.frontStream = new DeflaterOutputStream(this.out, this.deflater);
            }
        } else {
            throw new ZipException("unsupported compression method: " + zipEntry.method);
        }
        this.ongoingEntry = zipEntry;
        this.header.write(this.out, zipEntry);
    }

    public void closeEntry() throws IOException {
        int n;
        this.ensureOpen();
        this.flush();
        if (this.frontStream instanceof DeflaterOutputStream) {
            DeflaterOutputStream deflaterOutputStream = (DeflaterOutputStream)this.frontStream;
            deflaterOutputStream.finish();
            deflaterOutputStream.flush();
            this.frontStream = this.out;
        }
        this.ongoingEntry.crc = n = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        if (!this.ongoingEntry.isDirectory()) {
            if (this.ongoingEntry.hasEXT()) {
                this.ongoingEntry.compsize = this.deflater.getTotalOut();
                this.ongoingEntry.uncompsize = this.deflater.getTotalIn();
                this.header.writeEXT(this.out, this.ongoingEntry);
            } else if (this.ongoingEntry.method == 8 && (this.deflater.getTotalOut() != this.ongoingEntry.compsize || this.deflater.getTotalIn() != this.ongoingEntry.uncompsize)) {
                throw new ZipException("invalid header info");
            }
        }
        this.deflater.reset();
        this.crc.reset();
        this.ongoingEntry = null;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.crc.update(n);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.flush();
            this.header.writeEND(this.out);
            this.deflater.end();
        }
        finally {
            this.header = null;
            this.deflater = null;
            this.crc = null;
            this.ongoingEntry = null;
            super.close();
        }
    }
}

