/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.compression.lzhuf;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import jp.sfjp.armadillo.archive.lzh.LzhQuit;

public final class LzhHuffmanTable {
    private static final int MAX_CODE_LENGTH = 16;
    final int[] codeTable;
    final int[] codeLengthTable;

    private LzhHuffmanTable(int[] nArray) {
        int n = nArray.length;
        for (int i = n - 1; i >= 0 && nArray[i] <= 0; --i) {
            --n;
        }
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        this.build(nArray, n, nArray2, nArray3);
        this.codeTable = nArray2;
        this.codeLengthTable = nArray3;
    }

    public static LzhHuffmanTable build(int[] nArray) {
        return new LzhHuffmanTable(nArray);
    }

    private void build(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        int n2;
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = nArray[n2];
            if (n3 <= 0) continue;
            linkedList.add(new Node(n2, n3));
        }
        if (linkedList.size() < 2) {
            n2 = linkedList.size();
            if (n2 == 1) {
                nArray3[n - 1] = 1;
            } else if (n2 == 2) {
                Node node = (Node)linkedList.get(0);
                Node node2 = (Node)linkedList.get(1);
                int[] nArray4 = new int[]{node.number, node2.number};
                Arrays.sort(nArray4);
                nArray2[nArray4[0]] = 0;
                nArray3[nArray4[0]] = 1;
                nArray2[nArray4[1]] = 1;
                nArray3[nArray4[1]] = 1;
            }
            return;
        }
        n2 = n;
        while (linkedList.size() > 1) {
            Collections.sort(linkedList);
            Node node = (Node)linkedList.remove(0);
            Node node3 = (Node)linkedList.remove(0);
            linkedList.add(new Node(n2++, node, node3));
        }
        Node node = (Node)linkedList.get(0);
        LzhHuffmanTable.createCodeLengthTable(node, n, 0, nArray3);
        LzhHuffmanTable.createCodeTable(nArray2, nArray3);
    }

    private static void createCodeLengthTable(Node node, int n, int n2, int[] nArray) {
        if (n2 > 16) {
            throw new LzhQuit("code length = " + n2);
        }
        int n3 = node.number;
        if (n3 < n) {
            nArray[n3] = n2;
        } else {
            LzhHuffmanTable.createCodeLengthTable(node.left, n, n2 + 1, nArray);
            LzhHuffmanTable.createCodeLengthTable(node.right, n, n2 + 1, nArray);
        }
    }

    static int[] createCodeTable(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        LzhHuffmanTable.createCodeTable(nArray2, nArray);
        return nArray2;
    }

    static void createCodeTable(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[17];
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = nArray2[i];
            nArray3[n2] = nArray3[n2] + 1;
        }
        int[] nArray4 = new int[17];
        for (n = 0; n < 16; ++n) {
            nArray4[n + 1] = nArray4[n] + nArray3[n + 1] << 1;
        }
        assert (nArray4[16] == 131072) : nArray4[16];
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray2[n];
            if (n3 <= 0) continue;
            int n4 = n3 - 1;
            nArray4[n4] = nArray4[n4] + 1;
        }
    }

    private static final class Node
    implements Comparable<Node> {
        final int number;
        final int weight;
        Node left;
        Node right;

        public Node(int n, int n2) {
            this.number = n;
            this.weight = n2;
            this.left = null;
            this.right = null;
        }

        public Node(int n, Node node, Node node2) {
            this.number = n;
            this.weight = node.weight + node2.weight;
            this.left = node;
            this.right = node2;
        }

        @Override
        public int compareTo(Node node) {
            int n;
            int n2;
            if (node.weight == this.weight) {
                n2 = node.number;
                n = this.number;
            } else {
                n2 = this.weight;
                n = node.weight;
            }
            return n2 < n ? -1 : (n2 == n ? 0 : 1);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.left == null ? 0 : this.left.hashCode());
            n = 31 * n + this.number;
            n = 31 * n + (this.right == null ? 0 : this.right.hashCode());
            n = 31 * n + this.weight;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Node node = (Node)object;
            if (this.left == null ? node.left != null : !this.left.equals(node.left)) {
                return false;
            }
            if (this.number != node.number) {
                return false;
            }
            if (this.right == null ? node.right != null : !this.right.equals(node.right)) {
                return false;
            }
            return this.weight == node.weight;
        }

        public String toString() {
            return "Node:" + this.number + " (" + this.weight + ")";
        }
    }
}

