/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.compression.lzhuf;

import java.io.FilterInputStream;
import java.io.IOException;
import jp.sfjp.armadillo.compression.lzhuf.LzhufException;
import jp.sfjp.armadillo.compression.lzhuf.LzssDecoderReadable;

public final class LzssInputStream
extends FilterInputStream {
    private final int dictionarySize;
    private final int matchSize;
    private final int threshold;
    private final int bufferLength;
    private boolean closed;
    private LzssDecoderReadable input;
    private byte[] buffer;
    private int bufferedSize = 0;
    private int index = 0;
    private int limit = 0;

    public LzssInputStream(LzssDecoderReadable lzssDecoderReadable, int n, int n2, int n3) {
        super(null);
        this.input = lzssDecoderReadable;
        this.dictionarySize = n;
        this.matchSize = n2;
        this.threshold = n3;
        this.bufferLength = n + n2;
        this.buffer = new byte[this.bufferLength];
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
        try {
            if (this.bufferedSize < 1 && this.fillBuffer(1) > 0) {
                return -1;
            }
            --this.bufferedSize;
            return this.buffer[++this.index] & 0xFF;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhufException("decode error", runtimeException);
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
        try {
            int n3 = n;
            int n4 = n2;
            while (n4 > 0 && (n4 <= this.bufferedSize || this.fillBuffer(n4) != n4)) {
                int n5;
                int n6 = n5 = n4 <= this.bufferedSize ? n4 : this.bufferedSize;
                if (this.index < this.limit) {
                    System.arraycopy(this.buffer, this.index, byArray, n3, n5);
                    this.index += n5;
                } else {
                    int n7 = this.index + n5 > this.buffer.length ? this.buffer.length - this.index : n5;
                    System.arraycopy(this.buffer, this.index, byArray, n3, n7);
                    this.index += n7;
                    int n8 = n5 - n7;
                    if (n8 > 0) {
                        System.arraycopy(this.buffer, 0, byArray, n3 + n7, n8);
                        this.index = n8;
                    }
                }
                n4 -= n5;
                this.bufferedSize -= n5;
            }
            return n2 == n4 ? n2 : n2 - n4;
        }
        catch (RuntimeException runtimeException) {
            throw new LzhufException("decode error", runtimeException);
        }
    }

    private int fillBuffer(int n) throws IOException {
        int n2;
        int n3 = Math.min(n, this.dictionarySize);
        while (this.bufferedSize < n3 && (n2 = this.input.read()) != -1) {
            if (n2 >= 256) {
                int n4 = (n2 & 0xFF) + this.threshold;
                int n5 = this.input.readOffset();
                assert (n4 <= this.matchSize);
                int n6 = this.limit - n5 - 1;
                if (n6 < 0) {
                    n6 += this.bufferLength;
                }
                for (int i = 0; i < n4; ++i) {
                    this.buffer[this.limit++] = this.buffer[n6++];
                    if (n6 >= this.bufferLength) {
                        n6 -= this.bufferLength;
                    }
                    if (this.limit < this.bufferLength) continue;
                    this.limit -= this.bufferLength;
                }
                this.bufferedSize += n4;
                continue;
            }
            this.buffer[this.limit++] = (byte)(n2 & 0xFF);
            if (this.limit >= this.bufferLength) {
                this.limit -= this.bufferLength;
            }
            ++this.bufferedSize;
        }
        return n - this.bufferedSize;
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        long l3;
        byte[] byArray = new byte[8192];
        for (l2 = l; l2 > 0L; l2 -= (long)this.read(byArray, 0, (int)l3)) {
            l3 = Math.min((long)byArray.length, l2);
            assert (l3 <= Integer.MAX_VALUE);
        }
        return l - l2;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("stream already closed");
        }
        this.input.close();
    }
}

