/*
 * Decompiled with CFR 0.152.
 */
package jp.sfjp.armadillo.ui.window;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jp.sfjp.armadillo.ArmadilloCommands;
import jp.sfjp.armadillo.Logger;
import jp.sfjp.armadillo.ProgressNotifier;
import jp.sfjp.armadillo.ResourceManager;
import jp.sfjp.armadillo.archive.ArchiveEntry;
import jp.sfjp.armadillo.archive.ArchiveType;
import jp.sfjp.armadillo.ui.window.MainWindow;

public final class ListDialog
extends JDialog {
    static Logger log = Logger.getLogger(ListDialog.class);
    static ResourceManager res = ResourceManager.getInstance("jp.sfjp.armadillo.ui.messages");

    public ListDialog(final MainWindow mainWindow, final File file, ArchiveType archiveType, ProgressNotifier progressNotifier) throws IOException {
        super(mainWindow);
        Object object;
        Object object2;
        Object object3;
        this.setTitle(String.format("%s", file.getAbsolutePath()));
        this.setDefaultCloseOperation(2);
        List<ArchiveEntry> list = ArmadilloCommands.extractArchiveEntries(file, archiveType);
        Object[][] objectArray = new Object[list.size()][];
        int n = -1;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ArchiveEntry object42 : list) {
            object3 = object42.getCompressedSize() >= 0L ? Long.valueOf(object42.getCompressedSize()) : "";
            object2 = simpleDateFormat.format(new Date(object42.getLastModified()));
            object = new Object[]{object42.getName(), object42.getMethodName(), object42.getSize(), object3, object2};
            objectArray[++n] = object;
        }
        Object[] objectArray2 = new Object[]{res.get("label.list.name", new Object[0]), res.get("label.list.method", new Object[0]), res.get("label.list.size", new Object[0]), res.get("label.list.compsize", new Object[0]), res.get("label.list.mtime", new Object[0])};
        final JTable jTable = new JTable(objectArray, objectArray2);
        jTable.setAutoResizeMode(0);
        object3 = jTable.getColumnModel();
        object3.getColumn(0).setPreferredWidth(256);
        object3.getColumn(4).setPreferredWidth(124);
        jTable.getTableHeader().setResizingAllowed(false);
        object2 = new JScrollPane(jTable, 22, 32);
        this.add((Component)object2, "Center");
        object = new JButton(new AbstractAction(res.get("button.extractSelectedEntries", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                long l = 0L;
                for (int n : jTable.getSelectedRows()) {
                    linkedHashSet.add(String.valueOf(jTable.getValueAt(n, 0)));
                    l += this.toLong(jTable.getValueAt(n, 3));
                }
                mainWindow.startExtractAction(file, l, linkedHashSet);
            }

            private long toLong(Object object) {
                if (object == null) {
                    return 0L;
                }
                String string = String.valueOf(object).trim();
                if (string.isEmpty()) {
                    return 0L;
                }
                assert (string.matches("\\d+"));
                return Long.parseLong(string);
            }
        });
        this.add((Component)object, "North");
        this.pack();
    }

    void showInfoList(File file, List<ArchiveEntry> list) {
        this.setVisible(true);
    }
}

