package jp.sfjp.armadillo.archive.cab;

import java.io.*;
import jp.sfjp.armadillo.archive.*;
import jp.sfjp.armadillo.io.*;

public final class CabArchiveExtractor implements ArchiveExtractor {

    private CabInputStream is;

    public CabArchiveExtractor(InputStream is) {
        this.is = new CabInputStream(is);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(is.getNextEntry());
    }

    @Override
    public long extract(OutputStream os) throws IOException {
        return IOUtilities.transferAll(is, os);
    }

    @Override
    public void close() throws IOException {
        is.close();
    }

}
