package jp.sfjp.armadillo.archive.cab;

import static jp.sfjp.armadillo.archive.cab.CabCompressionType.Constants.*;

public enum CabCompressionType {

    No, MSZIP, Quantum, LZX, Unknown;

    public static CabCompressionType of(short type) {
        switch (type) {
            case iNo:
                return No;
            case iMSZIP:
                return MSZIP;
            case iQuantum:
                return Quantum;
            case iLZX:
                return LZX;
            default:
        }
        return Unknown;
    }

    static final class Constants {
        static final short iNo = 0x0000;
        static final short iMSZIP = 0x0001;
        static final short iQuantum = 0x0002;
        static final short iLZX = 0x0003;
    }

}
