package jp.sfjp.armadillo.archive.tar;

import java.io.*;
import jp.sfjp.armadillo.archive.*;
import jp.sfjp.armadillo.io.*;

public final class TarArchiveExtractor implements ArchiveExtractor {

    private TarInputStream is;

    public TarArchiveExtractor(InputStream is) {
        this.is = new TarInputStream(is);
    }

    @Override
    public ArchiveEntry nextEntry() throws IOException {
        return ArchiveEntry.orNull(is.getNextEntry());
    }

    @Override
    public long extract(OutputStream os) throws IOException {
        return IOUtilities.transferAll(is, os);
    }

    @Override
    public void close() throws IOException {
        is.close();
    }

}
