package jp.sfjp.armadillo.archive.tar;

import java.io.*;
import jp.sfjp.armadillo.archive.*;

public final class TarInputStream extends ArchiveInputStream {

    private TarHeader header;
    private long skipSize;

    public TarInputStream(InputStream is) {
        super(is);
        this.header = new TarHeader();
        this.skipSize = 0;
        frontStream = is;
    }

    public TarEntry getNextEntry() throws IOException {
        ensureOpen();
        if (remaining + skipSize > 0) {
            remaining += skipSize;
            while (remaining > 0) {
                long skipped = in.skip(remaining);
                remaining -= skipped;
            }
        }
        remaining = 0;
        skipSize = 0;
        TarEntry entry = header.read(in);
        if (entry == null)
            return null;
        long size = entry.getSize();
        remaining = size;
        skipSize = TarHeader.getSkipSize(size);
        return entry;
    }

    @Override
    public void close() throws IOException {
        header = null;
        super.close();
    }

}
