package jp.sfjp.armadillo.archive.tar;

import java.io.*;
import jp.sfjp.armadillo.archive.*;

public final class TarOutputStream extends ArchiveOutputStream {

    private TarHeader header;
    private TarEntry nextEntry;

    public TarOutputStream(OutputStream os) {
        super(os);
        this.header = new TarHeader();
        frontStream = os;
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        ensureOpen();
        nextEntry = entry;
        header.write(this, entry);
        written = 0;
    }

    public void closeEntry() throws IOException {
        ensureOpen();
        int skipSize = (int)TarHeader.getSkipSize(nextEntry.getSize());
        write(new byte[skipSize]);
        flush();
        nextEntry = null;
    }

    @Override
    public void close() throws IOException {
        try {
            header.writeEndOfArchive(this);
        }
        finally {
            try {
                super.close();
            }
            finally {
                header = null;
                nextEntry = null;
            }
        }
    }

}
