package jp.sfjp.armadillo.io;

import java.io.*;

public final class IOUtilities {

    private static final int BUFFER_SIZE = 8192;

    private IOUtilities() {
        // empty
    }

    public static long transfer(InputStream is, OutputStream os, long length) throws IOException {
        return transfer(new byte[BUFFER_SIZE], is, os, length);
    }

    public static long transfer(byte[] buffer, InputStream is, OutputStream os, long length) throws IOException {
        final int bufferSize = buffer.length;
        long rest = length;
        long totalSize = 0;
        while (rest > 0) {
            long requiredLength = Math.min(rest, bufferSize);
            assert requiredLength <= Integer.MAX_VALUE;
            int readLength = is.read(buffer, 0, (int)requiredLength);
            assert readLength != 0 : "Read Zero";
            if (readLength < 0) {
                break;
            }
            os.write(buffer, 0, readLength);
            rest -= readLength;
            totalSize += readLength;
        }
        os.flush();
        return totalSize;
    }

    public static long transferAll(InputStream is, OutputStream os) throws IOException {
        long totalSize = 0;
        byte[] buffer = new byte[BUFFER_SIZE];
        //        for (int readLength; (readLength = is.read(buffer)) >= 0;) {
        while (true) {
            final int readLength = is.read(buffer, 0, BUFFER_SIZE);
            if (readLength == 0)
                throw new IllegalStateException("illegal state");
            assert readLength != 0 : "Read Zero";
            if (readLength <= 0)
                break;
            try {
                os.write(buffer, 0, readLength);
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            totalSize += readLength;
        }
        os.flush();
        return totalSize;
    }

    public static int read(InputStream is, byte[] bytes, int offset, int length) throws IOException {
        int totalSize = 0;
        int p = offset;
        int q = length;
        while (q > 0) {
            final int readLength = is.read(bytes, p, q);
            assert readLength != 0 : "Read Zero";
            if (readLength <= 0)
                break;
            totalSize += readLength;
            p += readLength;
            q -= readLength;
        }
        return totalSize;
    }

    public static int readAll(InputStream is, byte[] bytes) throws IOException {
        return read(is, bytes, 0, bytes.length);
    }

}
