package jp.sfjp.armadillo.io;

import java.io.*;
import java.util.zip.*;

public final class InspectionOutputStream extends FilterOutputStream {

    private long size;
    private boolean hasChecksum;
    private Checksum checksum;

    public InspectionOutputStream(OutputStream os) {
        super(os);
        this.size = 0L;
    }

    public InspectionOutputStream(OutputStream os, Checksum checksum) {
        this(os);
        this.hasChecksum = checksum != null;
        this.checksum = checksum;
    }

    public void reset() {
        size = 0L;
        if (hasChecksum)
            checksum.reset();
    }

    public long getSize() {
        return size;
    }

    public Checksum getChecksum() {
        return checksum;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        ++size;
        if (hasChecksum)
            checksum.update(b);
    }

}
