package jp.sfjp.armadillo.time;

import java.util.*;

/**
 * FTIME.
 * This class is compatible with java.util.zip.ZipEntry .
 */
public final class FTime implements TimeConverter {

    public FTime() { // empty
    }

    @Override
    public int int32From(long ms) {
        final long converted = convert(ms);
        if (converted > Integer.MAX_VALUE || converted < 0) {
            final String msg = String.format("%d(%s) is out of the range", ms, new Date(ms));
            throw new IllegalArgumentException(msg);
        }
        return (int)(converted & 0xFFFFFFFF);
    }

    @Override
    public long int64From(long ms) {
        return convert(ms);
    }

    private static long convert(long ms) {
        if (ms < 315500400000L) // 1980-01-01T00:00:00
            return (1 << 21) | (1 << 16);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(ms);
        return (c.get(Calendar.YEAR) - 1980) << 25
               | (c.get(Calendar.MONTH) + 1) << 21
               | c.get(Calendar.DATE) << 16
               | c.get(Calendar.HOUR_OF_DAY) << 11
               | c.get(Calendar.MINUTE) << 5
               | (c.get(Calendar.SECOND) / 2);
    }

    public long toMillisecond(int mdate, int mtime) {
        final int ftime = (mdate << 16) | mtime & 0xFFFF;
        return toMilliseconds(ftime);
    }

    @Override
    public long toMilliseconds(long ftime) {
        final int t = (int)ftime;
        final int yearsFrom1980 = (t >>> 25 & 0x7F);
        final int month = t >>> 21 & 0x0F;
        final int day = (t >>> 16 & 0x1F);
        final int hours = t >>> 11 & 0x1F;
        final int minutes = t >>> 5 & 0x3F;
        final int seconds = (t & 0x1F) * 2;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        c.set(1980 + yearsFrom1980, month - 1, day, hours, minutes, seconds);
        return c.getTimeInMillis();
    }

}
