package jp.sfjp.armadillo.time;

import java.util.*;

public final class TimeT implements TimeConverter {

    public TimeT() { // empty
    }

    @Override
    public int int32From(long ms) {
        final long seconds = ms / 1000L;
        if (seconds > Integer.MAX_VALUE || seconds < Integer.MIN_VALUE) {
            final String msg = String.format("%d(%s) is out of the range", ms, new Date(ms));
            throw new IllegalArgumentException(msg);
        }
        return (int)seconds;
    }

    @Override
    public long int64From(long millisecond) {
        // 61bits available
        return millisecond / 1000L;
    }

    @Override
    public long toMilliseconds(long time) {
        return time * 1000L;
    }

}
