/*
 * Decompiled with CFR 0.152.
 */
package asanhtmlparser;

import asanhtmlparser.HtmlParserException;
import asanhtmlparser.ScannerPosition;
import asanhtmlparser.util.FileUtil;
import asanhtmlparser.util.Logger;
import java.io.File;
import java.net.URL;

public class CharReader {
    private static Logger logger;
    static final int EOF = -1;
    private URL url;
    String source;
    private int pos;
    private int line;
    private int col;
    static final /* synthetic */ boolean $assertionsDisabled;

    void setSource(String source, URL file) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.url = file;
        this.source = source;
        this.pos = 0;
        this.col = 1;
        this.line = 1;
    }

    int getChar() {
        return this.getChar0();
    }

    private int getChar0() {
        int ch;
        if (this.pos < this.source.length()) {
            ch = this.source.charAt(this.pos);
            ++this.pos;
            if (ch == 10) {
                ++this.line;
                this.col = 1;
            } else {
                ++this.col;
            }
        } else {
            ch = -1;
        }
        return ch;
    }

    void throwException(String message) throws HtmlParserException {
        throw new HtmlParserException(message, new ScannerPosition(this.url, this.pos, this.line, this.col));
    }

    void throwException(String message, Exception cause) throws HtmlParserException {
        throw new HtmlParserException(message, new ScannerPosition(this.url, this.pos, this.line, this.col), cause);
    }

    ScannerPosition getScannerPosition() {
        return new ScannerPosition(this.url, this.pos, this.line, this.col);
    }

    void setScannerPosition(ScannerPosition srcpos) {
        if (!$assertionsDisabled && srcpos == null) {
            throw new AssertionError();
        }
        logger.debug("setScannerPosition()");
        this.url = srcpos.url;
        this.pos = srcpos.pos;
        this.line = srcpos.line;
        this.col = srcpos.col;
        logger.debug(this.source.substring(0, this.pos) + "-----------------\n");
    }

    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            String source = FileUtil.readTextFile(file);
            CharReader scanner = new CharReader();
            scanner.setSource(source, null);
            int ch = -1;
            do {
                System.out.print(file + " " + scanner.pos + "(" + scanner.line + ";" + scanner.col + ")");
                ch = scanner.getChar();
                System.out.println("'" + (char)ch + "'");
            } while (ch != -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !CharReader.class.desiredAssertionStatus();
        logger = Logger.getLogger(CharReader.class);
    }
}

