/*
 * Decompiled with CFR 0.152.
 */
package asanhtmlparser;

import asanhtmlparser.IHtmlNode;
import asanhtmlparser.ScannerPosition;
import java.util.ArrayList;
import java.util.HashMap;

public class HtmlElement
implements IHtmlNode {
    public static final String OPEN_TAG = "OPEN";
    public static final String CLOSE_TAG = "CLOSE";
    public static final String SINGLE_TAG = "SINGLE";
    public String type;
    public final String tagname;
    public final ScannerPosition pos;
    private HashMap attrMap = new HashMap();
    private ArrayList attrList = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    HtmlElement(String type, String tagname, ScannerPosition pos) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && type != OPEN_TAG && type != CLOSE_TAG && type != SINGLE_TAG) {
            throw new AssertionError((Object)type);
        }
        if (!$assertionsDisabled && tagname == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pos == null) {
            throw new AssertionError();
        }
        this.type = type;
        this.tagname = tagname;
        this.pos = pos;
    }

    boolean addAttribute(String name, String value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        if (this.attrMap.containsKey(name)) {
            return false;
        }
        this.attrMap.put(name.toLowerCase(), value);
        this.attrList.add(name);
        return true;
    }

    void addAttribute(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.attrList.add(name);
    }

    public String getAttributeValue(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return (String)this.attrMap.get(name.toLowerCase());
    }

    public String getAttributeValue(String name, String defaultValue) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        String result = (String)this.attrMap.get(name.toLowerCase());
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getAttributeCount() {
        return this.attrList.size();
    }

    public String getAttributeName(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError(index);
        }
        return (String)this.attrList.get(index);
    }

    public String toString() {
        String result = "Element[" + this.tagname + " " + this.type + " attributes={";
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            String name;
            String value;
            if (i != 0) {
                result = result + "; ";
            }
            result = (value = this.getAttributeValue(name = this.getAttributeName(i))) != null ? result + name + "=\"" + value + "\"" : result + name;
        }
        return result + "}]";
    }

    static {
        $assertionsDisabled = !HtmlElement.class.desiredAssertionStatus();
    }
}

