/*
 * Decompiled with CFR 0.152.
 */
package asanhtmlparser;

import asanhtmlparser.CharReader;
import asanhtmlparser.HtmlComment;
import asanhtmlparser.HtmlElement;
import asanhtmlparser.HtmlError;
import asanhtmlparser.HtmlParserException;
import asanhtmlparser.HtmlText;
import asanhtmlparser.IHtmlNode;
import asanhtmlparser.ScannerPosition;
import asanhtmlparser.util.Logger;
import asanhtmlparser.util.NetUtil;
import java.net.URL;

public class HtmlScanner {
    private static Logger logger;
    CharReader reader = new CharReader();
    int ch = -1;
    private boolean badScriptTag = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setSource(String source, URL url) {
        if (!$assertionsDisabled && source == null) {
            throw new AssertionError();
        }
        this.reader.setSource(source, url);
        logger.debug(source);
        this.ch = this.reader.getChar();
        this.badScriptTag = false;
    }

    public IHtmlNode getToken() {
        ScannerPosition srcpos = this.reader.getScannerPosition();
        int ch0 = this.ch;
        try {
            return this.getToken(srcpos);
        }
        catch (HtmlParserException ex) {
            this.reader.setScannerPosition(srcpos);
            String result = "" + (char)ch0;
            this.ch = this.reader.getChar();
            while (this.ch != 60) {
                result = result + (char)this.ch;
                this.ch = this.reader.getChar();
                if (this.ch != -1) continue;
            }
            return new HtmlError(ex, result, srcpos);
        }
    }

    public IHtmlNode getToken(ScannerPosition srcpos) throws HtmlParserException {
        if (this.ch == -1) {
            return null;
        }
        if (this.badScriptTag) {
            this.badScriptTag = false;
            int end_pos = this.reader.source.toLowerCase().indexOf("</script>", srcpos.pos - 1);
            String text = "";
            while (this.reader.getScannerPosition().pos <= end_pos) {
                text = text + (char)this.ch;
                this.ch = this.reader.getChar();
            }
            return new HtmlText(text, srcpos);
        }
        if (this.ch == 60) {
            String type = "OPEN";
            this.ch = this.reader.getChar();
            if (this.ch == 33) {
                this.ch = this.reader.getChar();
                if (this.ch != 45) {
                    String sval = "";
                    while (this.ch != 62) {
                        sval = sval + this.ch;
                        this.ch = this.reader.getChar();
                    }
                    this.ch = this.reader.getChar();
                    return new HtmlElement("SINGLE", sval, srcpos);
                }
                this.ch = this.reader.getChar();
                if (this.ch != 45) {
                    this.reader.throwException("'-' \u304c\u3042\u308a\u307e\u305b\u3093:" + (char)this.ch);
                }
                this.ch = this.reader.getChar();
                this.ch = this.reader.getChar();
                return new HtmlComment(this.getHttpComment(srcpos), srcpos);
            }
            if (this.ch == 47) {
                type = "CLOSE";
                this.ch = this.reader.getChar();
                this.ch = this.skipWhiteSpace();
                if (this.ch == 62) {
                    this.ch = this.reader.getChar();
                    return new HtmlElement("SINGLE", "", srcpos);
                }
            }
            this.ch = this.skipWhiteSpace();
            String tagname = this.getIdentifier();
            this.ch = this.skipWhiteSpace();
            HtmlElement tag = new HtmlElement(type, tagname, srcpos);
            while (this.ch != 62 && this.ch != 47) {
                this.ch = this.skipWhiteSpace();
                String attrname = this.getAttributeName();
                this.ch = this.skipWhiteSpace();
                if (this.ch == 61) {
                    this.ch = this.reader.getChar();
                    this.ch = this.skipWhiteSpace();
                    String attrvalue = this.getAttributeValue();
                    logger.debug("name=" + attrname + " value=" + attrvalue + " ch=" + (char)this.ch);
                    if (attrvalue.startsWith("\"")) {
                        attrvalue = attrvalue.substring(1);
                    }
                    if (attrvalue.endsWith("\"")) {
                        attrvalue = attrvalue.substring(0, attrvalue.length() - 1);
                    }
                    tag.addAttribute(attrname.toLowerCase(), attrvalue);
                    continue;
                }
                logger.debug("name=" + null + " value=" + attrname + " ch=" + (char)this.ch);
                tag.addAttribute(attrname);
            }
            if (this.ch == 47) {
                tag.type = "SINGLE";
                this.ch = this.reader.getChar();
            }
            if (this.ch != 62) {
                this.reader.throwException("'>' \u304c\u3042\u308a\u307e\u305b\u3093 ch=" + (char)this.ch);
            }
            this.ch = this.reader.getChar();
            if (tag.tagname.equalsIgnoreCase("script") && tag.type == "OPEN") {
                int comment_pos = this.reader.source.indexOf("<!--", srcpos.pos);
                int end_pos = this.reader.source.toLowerCase().indexOf("</script>", srcpos.pos);
                if (comment_pos == -1 || end_pos < comment_pos) {
                    this.badScriptTag = true;
                }
            }
            return tag;
        }
        String text = "";
        do {
            text = text + (char)this.ch;
            this.ch = this.reader.getChar();
        } while (this.ch != 60 && this.ch != -1);
        return new HtmlText(text, srcpos);
    }

    int skipWhiteSpace() throws HtmlParserException {
        while (Character.isWhitespace((char)this.ch)) {
            this.ch = this.reader.getChar();
        }
        return this.ch;
    }

    String getIdentifier() throws HtmlParserException {
        if (!$assertionsDisabled && !Character.isJavaIdentifierStart((char)this.ch)) {
            throw new AssertionError(this.ch);
        }
        String sval = "";
        do {
            sval = sval + (char)this.ch;
            this.ch = this.reader.getChar();
        } while (Character.isJavaIdentifierPart((char)this.ch));
        return sval;
    }

    String getAttributeName() throws HtmlParserException {
        if (!$assertionsDisabled && !Character.isJavaIdentifierStart((char)this.ch)) {
            throw new AssertionError(this.ch);
        }
        String sval = "";
        while (this.ch != 32 && this.ch != 61 && this.ch != 47 && this.ch != 62) {
            sval = sval + (char)this.ch;
            this.ch = this.reader.getChar();
        }
        logger.debug("getAttributeName()=[" + sval + "] ch=" + (char)this.ch);
        return sval;
    }

    String getAttributeValue() throws HtmlParserException {
        if (!$assertionsDisabled && !Character.isJavaIdentifierStart((char)this.ch)) {
            throw new AssertionError(this.ch);
        }
        String sval = "";
        if (this.ch == 34) {
            sval = sval + this.getQuotedString('\"');
            return sval;
        }
        if (this.ch == 39) {
            sval = sval + this.getQuotedString('\'');
            return sval;
        }
        int ch0 = -1;
        ScannerPosition pos = null;
        while (this.ch != 62 && this.ch != 32) {
            if (this.ch == 47) {
                pos = this.reader.getScannerPosition();
            }
            if (ch0 == 47 && this.ch == 62) {
                sval = sval.substring(0, sval.length() - 1);
                this.reader.setScannerPosition(pos);
                break;
            }
            sval = sval + (char)this.ch;
            ch0 = this.ch;
            this.ch = this.reader.getChar();
        }
        logger.debug("getAttributeValue()=[" + sval + "] ch=" + (char)this.ch);
        return sval;
    }

    String getQuotedString(char quote) throws HtmlParserException {
        if (!$assertionsDisabled && this.ch != quote) {
            throw new AssertionError(this.ch);
        }
        String str = "" + quote;
        this.ch = this.reader.getChar();
        while (this.ch != quote) {
            str = str + (char)this.ch;
            this.ch = this.reader.getChar();
        }
        this.ch = this.reader.getChar();
        return str + quote;
    }

    String getHttpComment(ScannerPosition start) throws HtmlParserException {
        while (true) {
            this.ch = this.reader.getChar();
            ScannerPosition pos = this.reader.getScannerPosition();
            if (this.reader.source.startsWith("-->", pos.pos)) {
                this.ch = this.reader.getChar();
                this.ch = this.reader.getChar();
                this.ch = this.reader.getChar();
                this.ch = this.reader.getChar();
                return this.reader.source.substring(start.pos - 1, pos.pos + 3);
            }
            if (this.ch != -1) continue;
            this.reader.throwException("\u30b3\u30e1\u30f3\u30c8\u306e\u672b\u5c3e '-->' \u304c\u3042\u308a\u307e\u305b\u3093");
        }
    }

    public String skip() {
        String result = "";
        while (this.ch != 60) {
            result = result + (char)this.ch;
            this.ch = this.reader.getChar();
            if (this.ch != -1) continue;
            break;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        IHtmlNode node;
        System.out.println("HtmlScanner.main()");
        if (args.length == 0) {
            System.out.println("usage:java HtmlScanner <url>");
            return;
        }
        URL url = new URL(args[0]);
        System.out.println("url=" + url);
        byte[] bytes = NetUtil.downloadContents(url);
        String charset = "JISAutoDetect";
        String source = new String(bytes, charset);
        HtmlScanner scanner = new HtmlScanner();
        scanner.setSource(source, url);
        do {
            node = scanner.getToken();
            System.out.println(node);
        } while (node != null);
    }

    static {
        $assertionsDisabled = !HtmlScanner.class.desiredAssertionStatus();
        logger = Logger.getLogger(HtmlScanner.class);
    }
}

