/*
 * 쐬: 2008/11/20
 */
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

import asanhtmlparser.HtmlElement;
import asanhtmlparser.HtmlParser;
import asanhtmlparser.IHtmlNode;
import asanhtmlparser.util.FileUtil;
import asanhtmlparser.util.NetUtil;

/**
 * Yahooj[X̎ʐ^̃y[Wɂ摜_E[h܂B
 */
public class ImageCollector {
	public static void main(String[] args) throws Exception {
		URL url = new URL("http://headlines.yahoo.co.jp/hl?ty=p");
		File outdir = new File("ImageCollector.out");
		if (! outdir.exists()) outdir.mkdirs();
		HtmlParser parser = new HtmlParser();
		ArrayList taglist = parser.parse(url);
		// img^OsrcŁA摜炵gq̃f[^t@CɕۑB
		for (int i=0; i<taglist.size(); i++) {
			IHtmlNode node = (IHtmlNode) taglist.get(i);
			if (! (node instanceof HtmlElement)) continue;
			HtmlElement elem = (HtmlElement) node;
			if (! elem.tagname.equalsIgnoreCase("img")) continue;
			String src = elem.getAttributeValue("src");
			if (src == null) continue;
			// 摜炵gq̃f[^t@CɕۑB
			if (src.endsWith(".jpg") || src.endsWith(".jpeg") ||
					src.endsWith(".gif") || 
					src.endsWith(".png") || 
					src.endsWith(".bmp") ||
					src.endsWith(".ico")) {
				String filename = src.substring(src.lastIndexOf("/")+1);
				System.out.println(src+" -> "+filename);
				byte[] bytes = NetUtil.downloadContents(new URL(src));
				FileUtil.writeBinaryFile(new File(outdir, filename), bytes);
			}
		}
	}
}
