/*
 * 쐬: 2008/11/24
 */
import java.io.File;
import java.net.URL;
import java.util.ArrayList;

import asanhtmlparser.HtmlElement;
import asanhtmlparser.HtmlParser;
import asanhtmlparser.IHtmlNode;
import asanhtmlparser.util.FileUtil;
import asanhtmlparser.util.NetUtil;

/**
 * Yfreephotoľ ̎ʐ^_E[h܂B
 * http://www.dfnt.net/t/photo/freephoto/index.shtml
 */
public class ImageCollector2 {
	public static void main(String[] args) throws Exception {
		// 摜o͗p̃fBNg쐬
		File outdir = new File("ImageCollector2.out");
		if (! outdir.exists()) outdir.mkdirs();
		// URLɂ摜t@Cւ̃N擾AN̉摜_E[hB
		HtmlParser parser = new HtmlParser();
		URL url = new URL("http://www.dfnt.net/t/photo/freephoto/index.shtml");	// freephotoľ
		ArrayList taglist = parser.parse(url);
		String base = url.toString();
		// a^OhrefŁA摜炵gq̃f[^t@CɕۑB
		for (int i=0; i<taglist.size(); i++) {
			IHtmlNode node = (IHtmlNode) taglist.get(i);
			if (! (node instanceof HtmlElement)) continue;	// Ggł͂Ȃ
			HtmlElement elem = (HtmlElement) node;
			if (elem.type == HtmlElement.CLOSE_TAG) continue; // ^Oɂ͋Ȃ
			if (elem.tagname.compareToIgnoreCase("base") == 0) {
				base = elem.getAttributeValue("href", base);
			}
			if (! elem.tagname.equalsIgnoreCase("a")) continue;	// a^Oł͂Ȃ
			String href = elem.getAttributeValue("href");
			if (href == null) continue;		// hrefȂ
			// 摜炵gq̃f[^t@CɕۑB
			if (href.endsWith(".jpg") || href.endsWith(".jpeg") || href.endsWith(".png")) {
				String filename = href.substring(href.lastIndexOf("/")+1);
				System.out.println(href+" -> "+filename);
				byte[] bytes = NetUtil.downloadContents(new URL(new URL(base), href));
				FileUtil.writeBinaryFile(new File(outdir, filename), bytes);
			}
		}
	}
}
