package asanhtmlparser;

/*
 * 쐬: 2005/07/30
 */
import java.io.File;
import java.net.URL;

import asanhtmlparser.util.FileUtil;
import asanhtmlparser.util.Logger;

/**
 * t@C當ǂݍ݂܂.
 * sI[qFĂ܂B(CR,LF,CR+LF)
 * sAJʒuLĂ܂B
 * 
 * 
 */
public class CharReader {
	/** Oo */
    private static Logger logger = Logger.getLogger(CharReader.class);

    /** t@C̏I[킵܂. */
	static final int EOF = -1;

	/** t@C. */
	private URL url;
	/** \[Xt@C */
	String source;
	/** XL̈ʒu */
	private int pos;

	/** sԍ */
	private int line;
	/** Jʒu */
	private int col;

	/**
	 * \[Xt@Cݒ肷B
	 * @param source	\[X(nulls)
	 * @param file		t@C(null) ΘbIȏꍇnullw肷B
	 */
	void setSource(String source, URL file) {
		assert source != null;
        // oɐݒ
		this.url = file;
		this.source = source;
		this.pos = 0;
		this.line = this.col = 1;
	}

	int getChar() {
		return getChar0();
	}
	
	private int getChar0() {
		int ch;
		if (pos < source.length()) {
			ch = source.charAt(pos);
			pos++;
			// line;colύX
			if (ch == '\n') {
				line++;
				col = 1;
			} else {
				col++;
			}
		} else {
			ch = EOF;
		}
		return ch;
	}


	void throwException(String message) throws HtmlParserException {
		throw new HtmlParserException(message, new ScannerPosition(url, pos, line, col));
	}
	void throwException(String message, Exception cause) throws HtmlParserException {
		throw new HtmlParserException(message, new ScannerPosition(url, pos, line, col), cause);
	}
	/**
	 * ݂͊̌̏ԂԂB
	 * ƂŁAsetScannerPosition()ĂԂƁÂƂ̏Ԃɖ߂ƂłB
	 */
	ScannerPosition getScannerPosition() {
        //logger.fine("getScannerPosition()");
        return new ScannerPosition(url, pos, line, col);
	}
	/**
	 * ͊w肳ꂽԂɖ߂B
	 * @param srcpos
	 */
	void setScannerPosition(ScannerPosition srcpos) {
		assert srcpos != null;
        logger.debug("setScannerPosition()");
        this.url = srcpos.url;
        this.pos = srcpos.pos;
        this.line = srcpos.line;
        this.col = srcpos.col;
        logger.debug(source.substring(0, pos)+"-----------------\n");
	}

	/** P̃eXgp̃C. */
	public static void main(String[] args) {
		try {
			File file = new File(args[0]);
			String source = FileUtil.readTextFile(file);
			CharReader scanner = new CharReader();
			scanner.setSource(source, null);
			int ch = -1;
			do {
				System.out.print(file+" "+scanner.pos+"("+scanner.line+";"+scanner.col+")");
				ch = scanner.getChar();
				System.out.println("'"+(char)ch+"'");
			} while (ch != EOF);
		}
		catch (Exception ex) { ex.printStackTrace(); }
	}
}
