/*
 * 쐬: 2008/05/21
 */
package asanhtmlparser;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * HTML̃^O̓e.̏ێ܂.
 * 
 * @author a-san
 */
public class HtmlElement implements IHtmlNode {
	/** "&lt;TAG>" `̃^O. */
	public static final String OPEN_TAG = "OPEN";
	/** "&lt;/TAG>" `̃^O. */
	public static final String CLOSE_TAG = "CLOSE";
	/** "&lt;TAG/>" `̃^O. */
	public static final String SINGLE_TAG = "SINGLE";
	/** ǂ̌`̃^OH OPEN_TAG, CLOSE_TAG, SINGLE_TAĜꂩ. */
	public String type;
	/** ^O. "body"A"img" Ȃ. */
	public final String tagname;
	/** ^Oꂽ\[Ẍʒuł. */
	public final ScannerPosition pos;
	/**
	 * mapɊi[܂BMap&lt;String,String>B 
	 * OŒl̂Ȃ͊i[܂BÔݏɕϊĊi[Ă܂B
	 */
	private HashMap attrMap = new HashMap();
	/**
	 * ̖OlistɊi[܂BList&lt;String>B
	 * ̖OAl̂Ȃꍇi[܂BO͑啶ῗÂ܂܊i[Ă܂B
	 */
	private ArrayList attrList = new ArrayList();

	/**
	 * HTML̃Gg쐬܂B
	 * @param type		^Ǒ`BOPEN_TAG, CLOSE_TAG, SINGLE_TAĜꂩB
	 * @param tagname	^OBnullsB
	 * @param pos		^Oꂽ\[Ẍʒu.nullsB
	 */
	HtmlElement(String type, String tagname, ScannerPosition pos) {
		assert type != null;
		assert type == OPEN_TAG || type == CLOSE_TAG || type == SINGLE_TAG: type;
		assert tagname != null;
		assert pos != null;
		this.type = type;
		this.tagname = tagname;
		this.pos = pos;
	}
	/**
	 * ǉ܂B
	 * @param name	Bnulls.
	 * @param value	lBnulls.
	 * @return	łɓ̑ƁAl͒uꂸ false Ԃ܂BȂ true Ԃ܂B
	 */
	boolean addAttribute(String name, String value) {
		assert name != null;
		assert value != null;
//		if (attrMap == null) {
//			attrMap = new HashMap();
//			attrList = new ArrayList();
//		}
		if (attrMap.containsKey(name)) return false; 
		attrMap.put(name.toLowerCase(), value);
		//attrList.add(new Object[] { name, value});
		attrList.add(name);
		return true;
	}
	/**
	 * O̒l̂Ȃǉ܂B
	 * @param name	Bnulls.
	 */
	void addAttribute(String name) {
		assert name != null;
		attrList.add(name);
	}
	/**
	 * w肳ꂽȎ̒l擾܂B̑啶͓ꎋ܂B
	 * w肳ꂽ݂Ȃꍇ́AnullԂ܂B
	 * ܂Aw肳ꂽ݂͑邯ǁA̒lȂꍇnullԂ܂B
	 * @param	name	Bnulls
	 * @return	̒lB݂ȂꍇnullԂB
	 */
	public String getAttributeValue(String name) {
		assert name != null;
		return (String) attrMap.get(name.toLowerCase());
	}
	/**
	 * w肳ꂽȎ̒l擾܂B̑啶͓ꎋ܂B
	 * ݂Ȃꍇ defaultValue Ԃ܂B
	 * @param	name	Bnulls
	 * @param	defaultValue	݂Ȃꍇ̃ftHglBnull
	 * @return	̒lB݂ȂꍇdefaultValueԂ܂B
	 */
	public String getAttributeValue(String name, String defaultValue) {
		assert name != null;
		String result = (String) attrMap.get(name.toLowerCase());
		if (result == null) return defaultValue;
		return result;
	}
	/**
	 * ̐Ԃ܂Bl̂ȂȎ܂܂܂B
	 * @return ̐B
	 */
	public int getAttributeCount() {
		return attrList.size();
	}
	/**
	 * w肳ꂽԍ̑Ԃ܂Bl̂ȂȎ܂܂܂B
	 * 啶͕ێĂ܂BȂ킿AHTML"HRef"ƏĂ"HRef"Ԃ܂B
	 * @param	index	̔ԍ(0`)
	 * @return	̖O.
	 */
	public String getAttributeName(int index) {
		assert index >= 0: index;
		return (String) attrList.get(index);
	}
	/** Gg̓elԂfobO₷̌`ŏo͂܂B */
	public String toString() {
		String result = "Element[" + tagname+" "+type+" attributes={";
		for (int i=0; i<getAttributeCount(); i++) {
			if (i != 0) result += "; ";
			String name = getAttributeName(i);
			String value = getAttributeValue(name);
			if (value != null) {
				result += name + "=\"" + value + "\"";
			} else {
				result += name;
			}
		}
		return result + "}]";
	}
}
