/*
 * 쐬: 2008/07/19
 */
package asanhtmlparser.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 * Asañt@C֌W̃[eBeB.
 * @author a-san
 */
public class FileUtil {
    /**
     * eLXgt@CCɓǂݍ݂܂B 
     * @param	file	\[Xt@C. nulls
     * @param	charsetName	LN^Zbg("windows-31j"Ȃ) nulls
     * @return	\[Xt@C̓e
     */
	public static String readTextFile(File file, String charsetName) throws IOException {
		assert file != null;
		assert charsetName != null;
        String source = "";
        BufferedReader reader = null;
        try {
        	reader = new BufferedReader(new InputStreamReader(new FileInputStream(file), charsetName));
			while (reader.ready()) {
				String line = reader.readLine();
				source += line + "\n";
			}
			return source;
        } finally {
        	if (reader != null) try { reader.close(); } catch (IOException ex) {}
        }		
	}

	/**
     * eLXgt@CCɓǂݍ݂܂B R[h̓ftHĝ̂gp܂B
     * @param	file	\[Xt@C. nulls
     * @return	\[Xt@C̓e
     */
	public static String readTextFile(File file) throws IOException {
		assert file != null;
		return readTextFile(file, Charset.defaultCharset().name());
	}
    /**
     * oCit@CCɓǂݍ݂܂B 
     * @param	file	t@C. nulls
     * @return	\[Xt@C̓e
     */
	public static byte[] readBinaryFile(File file) throws IOException {
		assert file != null;
		assert file.length() <= Integer.MAX_VALUE: file.length();
		byte[] bytes = new byte[(int) file.length()];
        BufferedInputStream in = null;
        int off = 0;
        try {
        	in = new BufferedInputStream(new FileInputStream(file));
			while (in.available() > 0) {
				int len = in.available();
				off += in.read(bytes, off, len);
			}
			return bytes;
        } finally {
        	if (in != null) try { in.close(); } catch (IOException ex) {}
        }
	}
	/**
	 * oCit@CCɏ݂܂B
	 * @param	file	t@CBnulls
	 * @param	contents	t@C̓eBnulls
	 */
	public static void writeBinaryFile(File file, byte[] contents) throws IOException {
		assert file != null;
		assert contents != null;
		BufferedOutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(file));
			out.write(contents);
		} finally {
			if (out != null) try { out.close(); } catch (IOException ex) {}
		}
	}
	/**
	 * oCixœt@Cǂ𒲂ׂ܂B
	 * t@C̓ê݂r܂Bt@C̍쐬tAȂǂ͔r܂B
	 * TCY傫ȃt@C̏ꍇ́AԂ⃁ĝŒӂĂB
	 * @param f1	t@CPBnulls
	 * @param f2	t@CQBnulls
	 * @return	oCixœ̏ꍇAtrueԂ܂B
	 */
	public static boolean same(File f1, File f2) throws IOException {
		return FileUtil.readBinaryFile(f1).equals(FileUtil.readBinaryFile(f2));
	}
	/**
	 * w肳ꂽfBNg̃t@CċAIɒT܂B
	 * ߂lɂ́AfBNg܂܂܂B(".", ".."܂܂܂)
	 * @param dir	fBNgBnulls.
	 * @return t@CȂꍇ́A̔zԂ܂B(nullł͂Ȃ)
	 */
	public static ArrayList collectFiles(File dir) {
		assert dir != null;
		ArrayList result = new ArrayList();
		File[] files = dir.listFiles();
		for (int i=0; i<files.length; i++) {
			result.add(files[i]);
			if (files[i].isDirectory()) {
				result.addAll(collectFiles(files[i]));
			}
		}
		return result;
	}
	/** w肳ꂽeLXgt@CsƂɋ؂āAString̃XgƂĕԂ܂B */
    public static Collection loadLines(File file) throws IOException {
    	ArrayList result = new ArrayList();
    	BufferedReader reader = new BufferedReader(new FileReader(file));
    	while (reader.ready()) {
    		String line = reader.readLine();
    		if (line == null) break;
    		if (line.length() > 0) {
    			result.add(line);
    		}
    	}
    	return result;
    }
    public static void saveLines(File file, Collection collect) throws IOException {
    	PrintWriter writer = new PrintWriter(new FileWriter(file));
    	for (Iterator ite=collect.iterator(); ite.hasNext(); ) {
    		writer.println(ite.next());
    	}
    	writer.close();
    }
    	
}
