//
// Object_Struct
//

#include "AScript.h"

namespace AScript {

Object_Struct::Object_Struct(const Object_Struct &obj) : Object(obj)
{
}

Object_Struct::~Object_Struct()
{
}

Object *Object_Struct::Clone() const
{
	return new Object_Struct(*this);
}

String Object_Struct::ToString(Signal sig, bool exprFlag)
{
	bool evaluatedFlag = false;
	Value value = EvalMethod(sig, AScript_Symbol(__str__),
											ValueList::Null, evaluatedFlag);
	if (evaluatedFlag) return value.ToString(sig, false);
	String str;
	const Environment::Frame &frame = GetTopFrame();
	const ValueMap &valueMap = frame.GetValueMap();
	str += _pClass->GetName();
	str += _T("(");
	foreach_const (ValueMap, iter, valueMap) {
		if (iter != valueMap.begin()) str += _T(", ");
		str += iter->first->GetName();
		str += _T(" => ");
		str += iter->second.ToString(sig, true);
	}
	str += _T(")");
	return str;
}

Class_Struct::Class_Struct(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
}

Object *Class_Struct::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	return new Object_Struct((pClass == NULL)? this : pClass);
}

}
