#ifndef __OBJECT_LIST_H__
#define __OBJECT_LIST_H__

#include "Common.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_List / Object_List
//-----------------------------------------------------------------------------
class Class_List : public Class {
public:
	Class_List(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_List : public Object {
public:
	inline static Object_List *GetSelfObj(Context &context) {
		return dynamic_cast<Object_List *>(context.GetSelfObj());
	}
public:
	typedef std::vector<size_t> IndexList;
	class ValueVisitorEx : public ValueVisitor {
	private:
		Environment &_env;
		const ValueList &_valList;
		IndexList _indexList;
	public:
		inline ValueVisitorEx(Environment &env, const ValueList &valList) :
											_env(env), _valList(valList) {}
		virtual void Visit(Signal sig, const Value &value);
		inline IndexList &GetIndexList() { return _indexList; }
	};
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const TCHAR *name = AScript_Symbol(List)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
private:
	ValueList _valList;
public:
	inline Object_List(Class *pClass) : Object(pClass) {}
	inline Object_List(Class *pClass, size_t n, const Value &value) :
									Object(pClass), _valList(n, value) {}
	inline Object_List(const Object_List &obj) :
									Object(obj), _valList(obj._valList) {}
	virtual bool IsList() const;
	virtual Object *Clone() const;
	inline ValueList &GetList() { return _valList; }
	inline const ValueList &GetList() const { return _valList; }
	virtual Value GetByIndex(Signal sig, const Value &valueIdx) const;
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual String ToString(Signal sig, bool exprFlag);
	static void DoPadding(Signal sig, ValueList &valList, const Value &value);
};

}

#endif
