#include "Symbol.h"
#include "String.h"
#include "Value.h"
#include "Function.h"

//-----------------------------------------------------------------------------
// Heap access functions
//-----------------------------------------------------------------------------
#if defined(HAVE_WINDOWS_H)
// malloc() and free() don't work correctly when they're used across
// Windows' DLL boundary. see KB190799 in MSDN.
void *operator new (size_t bytes)
{
	return ::LocalAlloc(LMEM_FIXED, bytes);
}

void operator delete (void *p)
{
	::LocalFree(p);
}
#endif

namespace AScript {

const int MAX_STACK_LEVEL = 20000;

}
