//
// Object_Environment
//

#include "Object_Environment.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Environment
//-----------------------------------------------------------------------------
Object_Environment::Object_Environment(const Object_Environment &obj) :
													Object(obj), _env(obj._env)
{
}

Object_Environment::~Object_Environment()
{
}

Object *Object_Environment::Clone() const
{
	return new Object_Environment(*this);
}

String Object_Environment::ToString(Signal sig, bool exprFlag)
{
	String str;
	EnvType envType = _env.GetTopFrame().GetType();
	str += "<Environment:";
	str += GetEnvTypeName(envType);
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Environment
//-----------------------------------------------------------------------------
// Environment#eval(expr:Expr):map
AScript_DeclareMethod(Environment, eval)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "expr", VTYPE_Expr);
}

AScript_ImplementMethod(Environment, eval)
{
	Object_Environment *pSelf = Object_Environment::GetSelfObj(context);
	return context.GetExpr(0)->Exec(pSelf->GetEnv(), sig);
}

// assignment
Class_Environment::Class_Environment(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
	AScript_AssignMethod(Environment, eval);
}

Object *Class_Environment::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
