//
// Object_Error
//

#include "Object_Error.h"
#include "Expr.h"

namespace AScript {

Object_Error::Object_Error(const Object_Error &obj) : Object(obj), _errType(obj._errType)
{
}

Object_Error::~Object_Error()
{
}

Object *Object_Error::Clone() const
{
	return new Object_Error(*this);
}

String Object_Error::ToString(Signal sig, bool exprFlag)
{
	String rtn;
	rtn += "<error:";
	rtn += GetErrorTypeName(_errType);
	rtn += ">";
	return rtn;
}

Class_Error::Class_Error(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
}

Object *Class_Error::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
