#include "Symbol.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Symbol
//-----------------------------------------------------------------------------
Symbol::Symbol(UniqNumber uniqNum, const char *name) : _uniqNum(uniqNum)
{
	_name = new char[::strlen(name) + 1];
	::strcpy(_name, name);
}

Symbol::~Symbol()
{
	delete[] _name;
}

const Symbol *Symbol::Add(const char *name)
{
	return SymbolPool::GetInstance()->Add(name);
}

bool Symbol::IsFlowControlSymbol() const
{
	return 
		IsIdentical(AScript_Symbol(if_)) ||
		IsIdentical(AScript_Symbol(elsif)) ||
		IsIdentical(AScript_Symbol(repeat)) ||
		IsIdentical(AScript_Symbol(while_)) ||
		IsIdentical(AScript_Symbol(for_));
}

//-----------------------------------------------------------------------------
// SymbolList
//-----------------------------------------------------------------------------
String SymbolList::Join(const char *sep) const
{
	if (empty()) return String("");
	SymbolList::const_iterator ppSymbol = begin();
	String rtn((*ppSymbol)->GetName());
	ppSymbol++;
	for ( ; ppSymbol != end(); ppSymbol++) {
		rtn += sep;
		rtn += (*ppSymbol)->GetName();
	}
	return rtn;
}

String SymbolList::Join(const char sepChar) const
{
	char sep[2];
	sep[0] = sepChar;
	sep[1] = '\0';
	return Join(sep);
}

//-----------------------------------------------------------------------------
// SymbolSet
//-----------------------------------------------------------------------------
const SymbolSet SymbolSet::Null;

SymbolSet::SymbolSet(const SymbolSet &symbolSet)
{
	foreach_const (SymbolSet, ppSymbol, symbolSet) Insert(*ppSymbol);
}

void SymbolSet::operator=(const SymbolSet &symbolSet)
{
	foreach_const (SymbolSet, ppSymbol, symbolSet) Insert(*ppSymbol);
}

//-----------------------------------------------------------------------------
// SymbolPool
//-----------------------------------------------------------------------------
SymbolPool *SymbolPool::_pInst = NULL;

SymbolPool::~SymbolPool()
{
	foreach (Content, ppSymbol, _content) {
		Symbol::Delete(*ppSymbol);
	}
}

void SymbolPool::Initialize()
{
	if (_pInst == NULL) {
		_pInst = new SymbolPool();
		_pInst->_Initialize();
	}
}

void SymbolPool::_Initialize()
{
	AScript_RealizeSymbolEx(Str_Empty,		"");
	AScript_RealizeSymbolEx(Char_Plus,		"+");
	AScript_RealizeSymbolEx(Char_Multiply,	"*");
	AScript_RealizeSymbolEx(Char_Question,	"?");
	AScript_RealizeSymbolEx(Char_Modulo,	"%");
	AScript_RealizeSymbolEx(Char_And,		"&");
	AScript_RealizeSymbol(unknown);
	AScript_RealizeSymbol(number);
	AScript_RealizeSymbol(boolean);
	AScript_RealizeSymbol(symbol);
	AScript_RealizeSymbol(string);
	AScript_RealizeSymbol(complex);
	AScript_RealizeSymbol(Module);
	AScript_RealizeSymbol(Class);
	AScript_RealizeSymbol(Object);
	AScript_RealizeSymbol(Function);
	AScript_RealizeSymbol(List);
	AScript_RealizeSymbol(Matrix);
	AScript_RealizeSymbol(Dict);
	AScript_RealizeSymbol(File);
	AScript_RealizeSymbol(FileStat);
	AScript_RealizeSymbol(DateTime);
	AScript_RealizeSymbol(iterator);
	AScript_RealizeSymbol(Expr);
	AScript_RealizeSymbol(Environment);
	AScript_RealizeSymbol(Error);
	AScript_RealizeSymbol(semaphore);
	AScript_RealizeSymbol(Struct);
	AScript_RealizeSymbol(e);
	AScript_RealizeSymbol(pi);
	AScript_RealizeSymbol(nil);
	AScript_RealizeSymbol(zero);
	AScript_RealizeSymbol(raise);
	AScript_RealizeSymbolEx(true_,			"true");
	AScript_RealizeSymbolEx(false_,			"false");
	AScript_RealizeSymbol(j);
	AScript_RealizeSymbolEx(if_,			"if");
	AScript_RealizeSymbol(elsif);
	AScript_RealizeSymbolEx(else_,			"else");
	AScript_RealizeSymbol(repeat);
	AScript_RealizeSymbolEx(while_,			"while");
	AScript_RealizeSymbolEx(for_,			"for");
	AScript_RealizeSymbolEx(break_,			"break");
	AScript_RealizeSymbolEx(continue_,		"continue");
	AScript_RealizeSymbolEx(except_,		"except");
	AScript_RealizeSymbol(__init__);
	AScript_RealizeSymbol(__del__);
	AScript_RealizeSymbol(__str__);
	AScript_RealizeSymbol(__setprop__);
	AScript_RealizeSymbol(__getprop__);
	AScript_RealizeSymbol(super);
	AScript_RealizeSymbol(self);
	AScript_RealizeSymbolEx(static_,		"static");
	AScript_RealizeSymbolEx(const_,			"const");
	AScript_RealizeSymbolEx(_anonymous_,	"<>");
	AScript_RealizeSymbolEx(public_,		"public");
	AScript_RealizeSymbolEx(private_,		"private");
	AScript_RealizeSymbolEx(protected_,		"protected");
	AScript_RealizeSymbol(dynamic_scope);
	AScript_RealizeSymbol(inside_scope);
	AScript_RealizeSymbol(raw);
	AScript_RealizeSymbol(map);
	AScript_RealizeSymbol(nomap);
	AScript_RealizeSymbol(fork);
	AScript_RealizeSymbol(strict);
	AScript_RealizeSymbol(loose);
	AScript_RealizeSymbol(block);
	AScript_RealizeSymbol(list);
	AScript_RealizeSymbol(xlist);
	AScript_RealizeSymbol(set);
	AScript_RealizeSymbol(xset);
	AScript_RealizeSymbol(rev);
	AScript_RealizeSymbol(and);
	AScript_RealizeSymbol(or);
	AScript_RealizeSymbol(xor);
	AScript_RealizeSymbolEx(void_,			"void");
	AScript_RealizeSymbol(flat);
	AScript_RealizeSymbol(noflat);
	AScript_RealizeSymbol(icase);
	AScript_RealizeSymbol(chop);
	AScript_RealizeSymbol(index);
	AScript_RealizeSymbol(last_index);
	AScript_RealizeSymbol(indices);
	AScript_RealizeSymbol(ascend);
	AScript_RealizeSymbol(descend);
	AScript_RealizeSymbol(stable);
	AScript_RealizeSymbol(up);
	AScript_RealizeSymbol(down);
	AScript_RealizeSymbol(left);
	AScript_RealizeSymbol(right);
	AScript_RealizeSymbol(prev);
	AScript_RealizeSymbol(next);
	AScript_RealizeSymbol(name);
	AScript_RealizeSymbol(parent);
	AScript_RealizeSymbol(parents);
	AScript_RealizeSymbol(sibling);
	AScript_RealizeSymbol(siblings);
	AScript_RealizeSymbol(child);
	AScript_RealizeSymbol(children);
	AScript_RealizeSymbol(path);
	AScript_RealizeSymbol(shrinkable);
	AScript_RealizeSymbol(x);
	AScript_RealizeSymbol(y);
	AScript_RealizeSymbol(z);
}

const Symbol *SymbolPool::Add(const char *name)
{
	Symbol *pSymbol = new Symbol(_uniqNum, name);
	std::pair<Content::iterator, bool> rtn = _content.insert(pSymbol);
	if (rtn.second) {
		_uniqNum++;
	} else {
		Symbol::Delete(pSymbol);
	}
	pSymbol = *rtn.first;
	return pSymbol;
}

//-----------------------------------------------------------------------------
// OccurPattern
//-----------------------------------------------------------------------------
const Symbol *GetOccurPatternSymbol(OccurPattern occurPattern)
{
	return
		(occurPattern == OCCUR_ZeroOrOnce)? AScript_Symbol(Char_Question) :
		(occurPattern == OCCUR_ZeroOrMore)? AScript_Symbol(Char_Multiply) :
		(occurPattern == OCCUR_OnceOrMore)? AScript_Symbol(Char_Plus) :
		AScript_Symbol(Str_Empty);
}

}
