//-----------------------------------------------------------------------------
// AScript time module
//-----------------------------------------------------------------------------
#include "Module_time.h"
#include "Object_DateTime.h"

AScript_BeginModule(time)

//-----------------------------------------------------------------------------
// AScript module functions: time
//-----------------------------------------------------------------------------
// time.sleep(secs)
AScript_DeclareFunction(sleep)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "secs", VTYPE_Number);
}

#if defined(HAVE_WINDOWS_H)
AScript_ImplementFunction(sleep)
{
	::Sleep(static_cast<DWORD>(context.GetNumber(0) * 1000));
	return Value::Null;
}
#else
AScript_ImplementFunction(sleep)
{
	struct timeval tv;
	tv.tv_sec = 0;
	tv.tv_usec = static_cast<int>(context.GetNumber(0) * 1000000);
	::select(0, NULL, NULL, NULL, &tv);
	return Value::Null;
}
#endif

// time.gmtime(t?:number)
AScript_DeclareFunction(gmtime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	//DeclareArg(env, "t", VTYPE_Number, false, OCCUR_ZeroOrOnce);
}

#if defined(HAVE_WINDOWS_H)
AScript_ImplementFunction(gmtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		SYSTEMTIME st;
		::GetSystemTime(&st);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(st));
		return Value(pObj, VTYPE_DateTime);
	}
}
#else
AScript_ImplementFunction(gmtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		time_t t;
		::time(&t);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(t, false));
		return Value(pObj, VTYPE_DateTime);
	}
	return Value::Null;
}
#endif

// time.localtime(t?:number)
AScript_DeclareFunction(localtime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	//DeclareArg(env, "t", VTYPE_Number, false, OCCUR_ZeroOrOnce);
}

#if defined(HAVE_WINDOWS_H)
AScript_ImplementFunction(localtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		SYSTEMTIME st;
		::GetLocalTime(&st);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(st));
		return Value(pObj, VTYPE_DateTime);
	}
}
#else
AScript_ImplementFunction(localtime)
{
	if (context.IsNumber(0)) {
		return Value::Null;
	} else {
		time_t t;
		::time(&t);
		Object_DateTime *pObj = new Object_DateTime(env.GetClass_DateTime(), DateTime(t, true));
		return Value(pObj, VTYPE_DateTime);
	}
	return Value::Null;
}
#endif

// time.clock()
AScript_DeclareFunction(clock)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

#if defined(HAVE_WINDOWS_H)
AScript_ImplementFunction(clock)
{
	LARGE_INTEGER freq, counter;
	if (::QueryPerformanceFrequency(&freq) && ::QueryPerformanceCounter(&counter)) {
		return Value(static_cast<Number>(counter.QuadPart) / freq.QuadPart);
	} else {
		return Value(static_cast<Number>(::GetTickCount()) / 1000);
	}
}
#else
AScript_ImplementFunction(clock)
{
	return Value::Null;
}
#endif

// time.monthdays(year:number, month:number):map
AScript_DeclareFunction(monthdays)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "year", VTYPE_Number);
	DeclareArg(env, "month", VTYPE_Number);
}

AScript_ImplementFunction(monthdays)
{
	int year = static_cast<short>(context.GetNumber(0));
	int month = static_cast<char>(context.GetNumber(1));
	return Value(static_cast<Number>(DateTime::_GetDaysOfMonth(year, month)));
}

// time.weekday(year:number, month:number, day:number):map
AScript_DeclareFunction(weekday)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "year", VTYPE_Number);
	DeclareArg(env, "month", VTYPE_Number);
	DeclareArg(env, "day", VTYPE_Number);
}

AScript_ImplementFunction(weekday)
{
	int year = static_cast<short>(context.GetNumber(0));
	int month = static_cast<char>(context.GetNumber(1));
	int day = static_cast<char>(context.GetNumber(2));
	return Value(static_cast<Number>(DateTime::_GetDayOfWeek(year, month, day)));
}

// time.isleap(year:number):map
AScript_DeclareFunction(isleap)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "year", VTYPE_Number);
}

AScript_ImplementFunction(isleap)
{
	return Value(DateTime::_IsLeapYear(static_cast<short>(context.GetNumber(0))));
}

AScript_ModuleEntry()
{
	AScript_AssignFunction(sleep);
	AScript_AssignFunction(gmtime);
	AScript_AssignFunction(localtime);
	AScript_AssignFunction(clock);
	AScript_AssignFunction(monthdays);
	AScript_AssignFunction(weekday);
	AScript_AssignFunction(isleap);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(time)

AScript_DLLModuleEntry(time)
