#ifndef __OBJECT_FUNCTION_H__
#define __OBJECT_FUNCTION_H__

#include "Object.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Function / Object_Function
//-----------------------------------------------------------------------------
class Class_Function : public Class {
public:
	Class_Function(Class *pClassSuper);
	void Prepare();
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Function : public Object {
public:
	inline static Object_Function *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Function *>(context.GetSelfObj());
	}
protected:
	Function *_pFunc;
public:
	inline Object_Function(Class *pClass, Function *pFunc) :
									Object(pClass), _pFunc(pFunc) {}
	inline Object_Function(const Object_Function &obj) :
									Object(obj), _pFunc(obj._pFunc->IncRef()) {}
	~Object_Function();
	virtual bool IsFunction() const;
	virtual Object *Clone() const;
	inline Function *GetFunction() { return _pFunc; }
	inline const Function *GetFunction() const { return _pFunc; }
	virtual String ToString(Signal sig, bool exprFlag);
	virtual Value Call(Environment &env, Signal sig, ContextExpr &contextExpr);
	virtual Value Eval(Environment &env, Signal sig, Context &context) const;
};

class Object_WrappedMethod : public Object_Function {
public:
	inline static Object_WrappedMethod *GetSelfObj(Context &context) {
		return dynamic_cast<Object_WrappedMethod *>(context.GetSelfObj());
	}
protected:
	Value _valueSelf;
public:
	inline Object_WrappedMethod(Class *pClass, Function *pFunc, const Value &valueSelf) :
							Object_Function(pClass, pFunc), _valueSelf(valueSelf) {}
	inline Object_WrappedMethod(const Object_WrappedMethod &obj) :
							Object_Function(obj), _valueSelf(obj._valueSelf) {}
	~Object_WrappedMethod();
	virtual bool IsWrappedMethod() const;
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	virtual Value Call(Environment &env, Signal sig, ContextExpr &contextExpr);
	virtual Value Eval(Environment &env, Signal sig, Context &context) const;
	//inline Value GetSelf() const { return _valueSelf; }
};

}

#endif
