#ifndef __OBJECT_ITERATOR_H__
#define __OBJECT_ITERATOR_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Iterator
//-----------------------------------------------------------------------------
class Class_Iterator : public Class {
public:
	Class_Iterator(Class *pClassSuper);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Iterator : public Object {
public:
	inline static Object_Iterator *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Iterator *>(context.GetSelfObj());
	}
private:
	Iterator *_pIterator;
public:
	inline Object_Iterator(Class *pClass, Iterator *pIterator) :
									Object(pClass), _pIterator(pIterator) {}
	Object_Iterator(const Object_Iterator &obj);
	virtual ~Object_Iterator();
	virtual Object *Clone() const;
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline Iterator *GetIterator() const { return _pIterator; }
};

}

#endif
