#ifndef __OPTION_H__
#define __OPTION_H__

#include "Signal.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Option
//-----------------------------------------------------------------------------
class Option {
public:
	struct Info {
		const char *keyLong;
		char keyShort;
		bool needValueFlag;
	};
	typedef std::map<String, String> Map;
private:
	Map _map;
	const Info *_infoTbl;
	int _cntInfo;
public:
	inline Option(const Info *infoTbl, int cntInfo) :
									_infoTbl(infoTbl), _cntInfo(cntInfo) {}
	bool Parse(Signal sig, int &argc, const char *argv[]);
	bool IsSet(const char *key);
	const char *GetString(const char *key, const char *defValue) const;
	long GetLong(const char *key, long defValue) const;
private:
	const char *_GetString(const char *key) const;
};

}

#endif
