#ifndef __OBJECT_STRUCT_H__
#define __OBJECT_STRUCT_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Struct / Object_Struct
//-----------------------------------------------------------------------------
class Class_Struct : public Class {
public:
	Class_Struct(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Struct : public Object {
public:
	inline static Object_Struct *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Struct *>(context.GetSelfObj());
	}
public:
	inline Object_Struct(Class *pClass) : Object(pClass) {}
	Object_Struct(const Object_Struct &obj);
	virtual ~Object_Struct();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	const DeclarationList &GetDeclList() const;
};

}

#endif
