#ifndef __OBJECT_ENVIRONMENT_H__
#define __OBJECT_ENVIRONMENT_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Environment / Object_Environment
//-----------------------------------------------------------------------------
class Class_Environment : public Class {
public:
	Class_Environment(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Environment : public Object {
public:
	inline static Object_Environment *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Environment *>(context.GetSelfObj());
	}
private:
	Environment _env;
public:
	inline Object_Environment(Class *pClass, Environment &env) :
											Object(pClass), _env(env) {}
	Object_Environment(const Object_Environment &obj);
	inline Environment &GetEnv() { return _env; }
	virtual ~Object_Environment();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
