//
// Object_Semaphore
//

#include "Object_Semaphore.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Semaphore
//-----------------------------------------------------------------------------
Object_Semaphore::~Object_Semaphore()
{
}

Object *Object_Semaphore::Clone() const
{
	return new Object_Semaphore(*this);
}

String Object_Semaphore::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<semaphore:";
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Semaphore
//-----------------------------------------------------------------------------
// semaphore#wait()
AScript_DeclareMethod(Semaphore, wait)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Semaphore, wait)
{
	Object_Semaphore *pSelf = Object_Semaphore::GetSelfObj(context);
	pSelf->GetSemaphore().Wait();
	return Value::Null;
}

// semaphore#release()
AScript_DeclareMethod(Semaphore, release)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Semaphore, release)
{
	Object_Semaphore *pSelf = Object_Semaphore::GetSelfObj(context);
	pSelf->GetSemaphore().Release();
	return Value::Null;
}

// semaphore#session()
AScript_DeclareMethod(Semaphore, session)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareBlock(OCCUR_Once);
}

AScript_ImplementMethod(Semaphore, session)
{
	Object_Semaphore *pSelf = Object_Semaphore::GetSelfObj(context);
	const Function *pFuncBlock = GetBlockFunction(env, sig, context);
	if (sig.IsSignalled()) return Value::Null;
	pSelf->GetSemaphore().Wait();
	Environment envBlock(&env, ENVTYPE_Block);
	Context contextSub(ValueList::Null);
	Value result = pFuncBlock->Eval(envBlock, sig, contextSub);
	pSelf->GetSemaphore().Release();
	return result;
}

// assignment
Class_Semaphore::Class_Semaphore(Environment &env) :
									Class(env.LookupClass(VTYPE_Object))
{
	AScript_AssignMethod(Semaphore, wait);
	AScript_AssignMethod(Semaphore, release);
	AScript_AssignMethod(Semaphore, session);
}

Object *Class_Semaphore::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
