#ifndef __FUNCTION_H__
#define __FUNCTION_H__

#include "Common.h"
#include "Declaration.h"
#include "Environment.h"
#include "Parser.h"

// DeclareFunction
#define AScript_DeclareFunctionEx(name, nameAlias) \
class Func_##name : public Function { \
public: \
	Func_##name(Environment &env, const char *name = nameAlias); \
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const; \
}; \
Func_##name::Func_##name(Environment &env, const char *name) : \
							Function(env, Symbol::Add(name), FUNCTYPE_Function)

#define AScript_DeclareFunction(name) AScript_DeclareFunctionEx(name, #name)

// DeclareFunctionWithDiffUnary
#define AScript_DeclareFunctionWithDiffUnaryEx(name, nameAlias) \
class Func_##name : public Function { \
public: \
	Func_##name(Environment &env, const char *name = nameAlias); \
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const; \
	virtual Expr *DiffUnary(Environment &env, Signal sig, const Expr *pExprArg, const Symbol *pSymbol) const; \
}; \
Func_##name::Func_##name(Environment &env, const char *name) : \
							Function(env, Symbol::Add(name), FUNCTYPE_Function)

#define AScript_DeclareFunctionWithDiffUnary(name) \
AScript_DeclareFunctionWithDiffUnaryEx(name, #name)

// DeclareFunctionSucceedable
#define AScript_DeclareFunctionSucceedableEx(name, nameAlias) \
class Func_##name : public Function { \
public: \
	Func_##name(Environment &env, const char *name = nameAlias); \
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const; \
	virtual bool IsSucceedable(const ICallable *pCallable) const; \
}; \
Func_##name::Func_##name(Environment &env, const char *name) : \
							Function(env, Symbol::Add(name), FUNCTYPE_Function)

#define AScript_DeclareFunctionSucceedable(name) \
AScript_DeclareFunctionSucceedableEx(name, #name)

// DeclareMethod
#define AScript_DeclareMethodEx(className, name, nameAlias) \
class Func_##className##__##name : public Function { \
public: \
	Func_##className##__##name(Environment &env, const char *name = nameAlias); \
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const; \
}; \
Func_##className##__##name::Func_##className##__##name(Environment &env, const char *name) : \
							Function(env, Symbol::Add(name), FUNCTYPE_Instance)

#define AScript_DeclareMethod(className, name) AScript_DeclareMethodEx(className, name, #name)

#define AScript_ImplementFunction(name) \
Value Func_##name::DoEval(Environment &env, Signal sig, Context &context) const

#define AScript_ImplementMethod(className, name) \
Value Func_##className##__##name::DoEval(Environment &env, Signal sig, Context &context) const

#define AScript_ImplementDiffUnary(name) \
Expr *Func_##name::DiffUnary(Environment &env, Signal sig, const Expr *pExprArg, const Symbol *pSymbol) const

#define AScript_Function(name) Func_##name

#define AScript_Method(className, name) Func_##className##__##name

#define AScript_DeclareFunctionBegin(name) \
class Func_##name : public Function {

#define AScript_DeclareFunctionEnd(name) \
public: \
	Func_##name(Environment &env, const char *name = #name); \
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const; \
}; \
Func_##name::Func_##name(Environment &env, const char *name) : \
							Function(env, Symbol::Add(name), FUNCTYPE_Function)

#define AScript_AssignFunction(name) \
env.AssignFunction(new Func_##name(env))

#define AScript_AssignFunctionEx(name, arg1) \
env.AssignFunction(new Func_##name(env, arg1))

#define AScript_AssignFunctionExx(name, arg1, arg2) \
env.AssignFunction(new Func_##name(env, arg1, arg2))

#define AScript_AssignMethod(className, name) \
AssignFunction(new Func_##className##__##name(*this))

#define AScript_AssignMethodEx(className, name, arg1) \
AssignFunction(new Func_##className##__##name(*this, arg1))

#define AScript_AssignMethodExx(className, name, arg1, arg2) \
AssignFunction(new Func_##className##__##name(*this, arg1, arg2))

#define AScript_AssignValue(name, value) \
env.AssignValue(Symbol::Add(#name), value, false)

#define AScript_AssignValueEx(name, value) \
env.AssignValue(Symbol::Add(name), value, false)

#define AScript_BlockSignalHandlerInLoop(sig, result, returnOnSignal) \
if ((sig).IsBreak()) { \
	result = (sig).GetValue(); \
	(sig).ClearSignal(); \
	break; \
} else if ((sig).IsReturn()) { \
	break; \
} else if ((sig).IsContinue()) { \
	result = (sig).GetValue(); \
	(sig).ClearSignal(); \
} else if ((sig).IsSignalled()) { \
	return returnOnSignal; \
}

namespace AScript {

class ExprList;
class Expr_Block;
class Expr_Caller;
class Class_Custom;
class FunctionCustom;
class Object_Dict;
class ICallable;
class IteratorOwner;

//-----------------------------------------------------------------------------
// FunctionType
//-----------------------------------------------------------------------------
enum FunctionType {
	FUNCTYPE_Function,
	FUNCTYPE_Class,
	FUNCTYPE_Instance,
	FUNCTYPE_Block,
};

const char *GetFuncTypeName(FunctionType funcType);

//-----------------------------------------------------------------------------
// ReulstMode
//-----------------------------------------------------------------------------
enum ResultMode {
	RSLTMODE_Normal,
	RSLTMODE_List,	// :list
	RSLTMODE_XList,	// :xlist
	RSLTMODE_Set,	// :set
	RSLTMODE_XSet,	// :xset
	RSLTMODE_Void,	// :void
};

//-----------------------------------------------------------------------------
// MapFlag
//-----------------------------------------------------------------------------
enum MapFlag {
	MAP_Off,
	MAP_On,
};

//-----------------------------------------------------------------------------
// FlatFlag
//-----------------------------------------------------------------------------
enum FlatFlag {
	FLAT_Off,
	FLAT_On,
};

//-----------------------------------------------------------------------------
// ForkFlag
//-----------------------------------------------------------------------------
enum ForkFlag {
	FORK_Off,
	FORK_On,
};

//-----------------------------------------------------------------------------
// ContextBase
//-----------------------------------------------------------------------------
class ContextBase {
private:
	const SymbolSet &_attrs;
	const SymbolSet &_attrsOpt;
	const Expr_Block *_pExprBlock;
	Function *_pFuncBlock;
	const Function **_ppFuncSuccRequester;
	Value _valueSelf;
	ResultMode _rsltMode;
	FlatFlag _flatFlag;
	ForkFlag _forkFlag;
public:
	ContextBase(const SymbolSet &attrs, const SymbolSet &attrsOpt,
				const Expr_Block *pExprBlock, const Function **ppFuncSuccRequester,
				const Value &valueSelf,
				ResultMode rsltMode = RSLTMODE_Normal, FlatFlag flatFlag = FLAT_Off);
	ContextBase(ContextBase &context);
	ContextBase(ContextBase &context,
				ResultMode rsltMode, FlatFlag flatFlag = FLAT_Off);
	virtual ~ContextBase();
	inline bool IsSet(const Symbol *pSymbol) const {
		return _attrs.IsSet(pSymbol);
	}
	inline bool IsAttrEmpty() const { return _attrs.empty(); }
	inline const SymbolSet &GetAttrs() const { return _attrs; }
	inline const SymbolSet &GetAttrsOpt() const { return _attrsOpt; }
	inline const Expr_Block *GetBlock() const { return _pExprBlock; }
	inline void SetSelf(const Value &valueSelf) { _valueSelf = valueSelf; }
	inline Value &GetSelf() { return _valueSelf; }
	inline Class *GetSelfClass() { return _valueSelf.GetClass(); }
	inline Object *GetSelfObj() { return _valueSelf.GetObject(); }
	inline bool IsBlockSpecified() const { return _pExprBlock != NULL; }
	inline bool IsRsltNormal() const { return _rsltMode == RSLTMODE_Normal; }
	inline bool IsRsltList() const { return _rsltMode == RSLTMODE_List; }
	inline bool IsRsltXList() const { return _rsltMode == RSLTMODE_XList; }
	inline bool IsRsltSet() const { return _rsltMode == RSLTMODE_Set; }
	inline bool IsRsltXSet() const { return _rsltMode == RSLTMODE_XSet; }
	inline bool IsRsltVoid() const { return _rsltMode == RSLTMODE_Void; }
	inline bool IsRsltFlat() const { return _flatFlag == FLAT_On; }
	inline void RequestSucceeding(const Function *pFuncSuccRequester) {
		if (_ppFuncSuccRequester != NULL) *_ppFuncSuccRequester = pFuncSuccRequester;
	}
	inline void SetFuncBlock(Function *pFunc) { _pFuncBlock = pFunc; }
	inline const Function *GetFuncBlock() const { return _pFuncBlock; }
};

//-----------------------------------------------------------------------------
// ContextExpr
//-----------------------------------------------------------------------------
class ContextExpr : public ContextBase {
private:
	const ExprList &_exprListArg;
public:
	inline ContextExpr(const SymbolSet &attrs, const SymbolSet &attrsOpt,
				const Expr_Block *pExprBlock, const Function **ppFuncSuccRequester,
				const Value &valueSelf, const ExprList &exprListArg) :
			ContextBase(attrs, attrsOpt, pExprBlock, ppFuncSuccRequester, valueSelf),
			_exprListArg(exprListArg) {}
	inline ContextExpr(const ExprList &exprListArg) :
			ContextBase(SymbolSet::Null, SymbolSet::Null, NULL, NULL, Value::Null),
			_exprListArg(exprListArg) {}
	inline const ExprList &GetArgs() const { return _exprListArg; }
};

//-----------------------------------------------------------------------------
// Context
//-----------------------------------------------------------------------------
class Context : public ContextBase {
private:
	const ValueList &_valListArg;
	const Value &_valueWithDict;
public:
	inline Context(const SymbolSet &attrs, const SymbolSet &attrsOpt,
				const Expr_Block *pExprBlock, const Function **ppFuncSuccRequester,
				const Value &valueSelf, const ValueList &valListArg,
				const Value &valueWithDict = Value::Null,
				ResultMode rsltMode = RSLTMODE_Normal, FlatFlag flatFlag = FLAT_Off) :
			ContextBase(attrs, attrsOpt, pExprBlock,
							ppFuncSuccRequester, valueSelf, rsltMode, flatFlag),
			_valListArg(valListArg), _valueWithDict(valueWithDict) {}
	inline Context(const ValueList &valListArg) :
			ContextBase(SymbolSet::Null, SymbolSet::Null, NULL, NULL, Value::Null),
			_valListArg(valListArg), _valueWithDict(Value::Null) {}
	inline Context(const ValueList &valListArg, const Value &valueWithDict) :
			ContextBase(SymbolSet::Null, SymbolSet::Null, NULL, NULL, Value::Null),
			_valListArg(valListArg), _valueWithDict(valueWithDict) {}
	inline Context(ContextBase &contextBase,
			const ValueList &valListArg, const Value &valueWithDict) :
			ContextBase(contextBase),
			_valListArg(valListArg), _valueWithDict(valueWithDict) {}
	inline Context(ContextBase &contextBase, ResultMode rsltMode, FlatFlag flatFlag,
				const ValueList &valListArg, const Value &valueWithDict) :
			ContextBase(contextBase, rsltMode, flatFlag),
			_valListArg(valListArg), _valueWithDict(valueWithDict) {}
	inline size_t CountArgs() const { return _valListArg.size(); }
	inline const ValueList &GetArgs() const { return _valListArg; }
	inline Value GetValue(size_t idxArg) {
		return (idxArg < _valListArg.size())? _valListArg[idxArg] : Value::Null;
	}
	inline const Value &GetValue(size_t idxArg) const {
		return (idxArg < _valListArg.size())? _valListArg[idxArg] : Value::Null;
	}
	inline bool IsValid(size_t idxArg) const			{ return GetValue(idxArg).IsValid();	}
	inline bool IsInvalid(size_t idxArg) const			{ return GetValue(idxArg).IsInvalid();	}
	inline bool IsNumber(size_t idxArg) const			{ return GetValue(idxArg).IsNumber();	}
	inline bool IsBoolean(size_t idxArg) const			{ return GetValue(idxArg).IsBoolean();	}
	inline bool IsSymbol(size_t idxArg) const			{ return GetValue(idxArg).IsSymbol();	}
	inline bool IsString(size_t idxArg) const			{ return GetValue(idxArg).IsString();	}
	inline bool IsComplex(size_t idxArg) const			{ return GetValue(idxArg).IsComplex();	}
	inline bool IsModule(size_t idxArg) const			{ return GetValue(idxArg).IsModule();	}
	inline bool IsClass(size_t idxArg) const			{ return GetValue(idxArg).IsClass();	}
	inline bool IsGenericObject(size_t idxArg) const	{ return GetValue(idxArg).IsGenericObject(); }
	inline bool IsFunction(size_t idxArg) const			{ return GetValue(idxArg).IsFunction();	}
	inline bool IsIterator(size_t idxArg) const			{ return GetValue(idxArg).IsIterator();	}
	inline bool IsList(size_t idxArg) const				{ return GetValue(idxArg).IsList();		}
	inline bool IsDict(size_t idxArg) const				{ return GetValue(idxArg).IsDict();		}
	inline bool IsFile(size_t idxArg) const				{ return GetValue(idxArg).IsFile();		}
	inline bool IsExpr(size_t idxArg) const				{ return GetValue(idxArg).IsExpr();		}
	inline bool IsError(size_t idxArg) const			{ return GetValue(idxArg).IsError();	}
	inline bool IsNumberOrComplex(size_t idxArg) const	{ return GetValue(idxArg).IsNumberOrComplex(); }
	inline Number GetNumber(size_t idxArg) const		{ return GetValue(idxArg).GetNumber();	}
	inline int GetInt(size_t idxArg) const				{ return GetValue(idxArg).GetInt();		}
	inline unsigned int GetUInt(size_t idxArg) const	{ return GetValue(idxArg).GetUInt();	}
	inline size_t GetSizeT(size_t idxArg) const			{ return GetValue(idxArg).GetSizeT();	}
	inline char GetChar(size_t idxArg) const			{ return GetValue(idxArg).GetChar();	}
	inline unsigned char GetUChar(size_t idxArg) const	{ return GetValue(idxArg).GetUChar();	}
	inline short GetShort(size_t idxArg) const			{ return GetValue(idxArg).GetShort();	}
	inline unsigned short GetUShort(size_t idxArg) const{ return GetValue(idxArg).GetUShort();	}
	inline long GetLong(size_t idxArg) const			{ return GetValue(idxArg).GetLong();	}
	inline unsigned long GetULong(size_t idxArg) const	{ return GetValue(idxArg).GetULong();	}
	inline bool GetBoolean(size_t idxArg) const			{ return GetValue(idxArg).GetBoolean();	}
	inline const Symbol *GetSymbol(size_t idxArg) const	{ return GetValue(idxArg).GetSymbol();	}
	inline const char *GetString(size_t idxArg) const	{ return GetValue(idxArg).GetString();	}
	inline const Bytes &GetBytes(size_t idxArg) const	{ return GetValue(idxArg).GetBytes();	}
	inline Object_String *GetStringObj(size_t idxArg)	{ return GetValue(idxArg).GetStringObj(); }
	inline const Object_String *GetStringObj(size_t idxArg) const	{ return GetValue(idxArg).GetStringObj();	}
	inline Object_File *GetFileObj(size_t idxArg)		{ return GetValue(idxArg).GetFileObj();	}
	inline Complex GetComplex(size_t idxArg) const		{ return GetValue(idxArg).GetComplex();	}
	inline Module *GetModule(size_t idxArg)				{ return GetValue(idxArg).GetModule();	}
	inline const Module *GetModule(size_t idxArg) const	{ return GetValue(idxArg).GetModule();	}
	inline const ValueList &GetList(size_t idxArg) const{ return GetValue(idxArg).GetList();	}
	inline Object_List *GetListObj(size_t idxArg)		{ return GetValue(idxArg).GetListObj(); }
	inline const Object_List *GetListObj(size_t idxArg) const{ return GetValue(idxArg).GetListObj(); }
	inline Iterator *GetIterator(size_t idxArg) const	{ return GetValue(idxArg).GetIterator();}
	inline File &GetFile(size_t idxArg)					{ return GetValue(idxArg).GetFile();	}
	inline File &GetFile(size_t idxArg) const			{
		return const_cast<Context *>(this)->GetValue(idxArg).GetFile();
	}
	inline const Expr *GetExpr(size_t idxArg) const		{ return GetValue(idxArg).GetExpr();	}
	inline Function *GetFunction(size_t idxArg)			{ return GetValue(idxArg).GetFunction(); }
	inline const Function *GetFunction(size_t idxArg) const	{ return GetValue(idxArg).GetFunction(); }
	inline Object_Function *GetFunctionObj(size_t idxArg) { return GetValue(idxArg).GetFunctionObj(); }
	inline const Object_Function *GetFunctionObj(size_t idxArg) const { return GetValue(idxArg).GetFunctionObj(); }
	inline ErrorType GetErrorType(size_t idxArg) const	{ return GetValue(idxArg).GetErrorType(); }
	inline const Value &GetValueWithDict() const		{ return _valueWithDict;				}
	inline const ValueDict &GetDict() const				{
		return _valueWithDict.IsDict()? _valueWithDict.GetDict() : ValueDict::Null;
	}
};

//-----------------------------------------------------------------------------
// ICallable
//-----------------------------------------------------------------------------
class ICallable {
public:
	Value EvalExpr(Environment &env, Signal sig, const Value &valueSelf,
			const Expr_Caller *pExprCaller, const Function **ppFuncSuccRequester);
	virtual Value Call(Environment &env, Signal sig, ContextExpr &contextExpr) = 0;
};

//-----------------------------------------------------------------------------
// Function
//-----------------------------------------------------------------------------
class Function {
public:
	class ResultListComposer {
	private:
		Environment &_env;
		ContextBase &_contextBase;
		Value &_result;
		ValueList *_pValList;
		size_t _cnt;
		bool _excludeNilFlag;
		bool _setFlag;
	public:
		ResultListComposer(Environment &env, ContextBase &contextBase, Value &result);
		Environment &GetEnv() { return _env; }
		void Store(const Value &value);
	};
	typedef std::map<const Symbol *, const Expr *, Symbol::KeyCompare_UniqNumber> ExprMap;
protected:
	int _cntRef;
	const Symbol *_pSymbol;
	const Symbol *_pSymbolDict;
	Environment _envScope;
	DeclarationOwner _declOwner;
	Parser::ElemType _elemType;
	String _mathSymbol;
	FunctionType _funcType;
	ResultMode _rsltMode;
	MapFlag _mapFlag;
	FlatFlag _flatFlag;
	ForkFlag _forkFlag;
	SymbolSet _attrsOpt;
	String _help;
	bool _dynamicScopeFlag;
	bool _allowTooManyArgsFlag;
	bool _symbolFuncFlag;
	struct {
		OccurPattern occurPattern;
		bool insideScopeFlag;
		bool quoteFlag;	// don't create function object from block
		const Symbol *pSymbol;
	} _blockInfo;
public:
	Function(const Function &func);
	Function(Environment &envScope, const Symbol *pSymbol, FunctionType funcType);
	virtual ~Function();
	inline Function *IncRef() const {
		Function *pFunc = const_cast<Function *>(this);
		pFunc->_cntRef++;
		return pFunc;
	}
	inline int DecRef() { _cntRef--; return _cntRef; }
	inline int GetRefCnt() const { return _cntRef; }
	inline static void Delete(Function *pFunc) {
		if (pFunc != NULL && pFunc->DecRef() <= 0) delete pFunc;
	}
	inline void SetOperatorInfo(Parser::ElemType elemType, const char *mathSymbol) {
		_elemType = elemType; _mathSymbol = mathSymbol;
	}
	inline void SetAsSymbolFunc() { _symbolFuncFlag = true; }
	inline bool IsSymbolFunc() const { return _symbolFuncFlag; }
	inline bool IsAnonymous() const { return _pSymbol->IsIdentical(AScript_Symbol(_anonymous_)); }
	inline void SetSymbol(const Symbol *pSymbol) { _pSymbol = pSymbol; }
	inline const Symbol *GetSymbol() const { return _pSymbol; }
	inline const char *GetName() const { return _pSymbol->GetName(); }
	inline Parser::ElemType GetElemType() const { return _elemType; }
	inline const char *GetMathSymbol() const { return _mathSymbol.c_str(); }
	inline Environment &GetEnvScope() { return _envScope; }
	inline Environment &GetEnvScope() const {
		return const_cast<Function *>(this)->_envScope;
	}
	virtual bool IsCustom() const;
	virtual bool IsPos() const;
	virtual bool IsNeg() const;
	virtual bool IsPlus() const;
	virtual bool IsMinus() const;
	virtual bool IsMultiply() const;
	virtual bool IsDivide() const;
	virtual bool IsModulo() const;
	virtual bool IsPower() const;
	virtual bool IsContainCheck() const;
	virtual bool IsStructPrototype() const;
	virtual Class *GetClassToConstruct() const;
	Value EvalExpr(Environment &env, Signal sig, ContextExpr &contextExpr) const;
	Value Eval(Environment &env, Signal sig, Context &context) const;
	Value EvalFuncBinder(Environment &env, Signal sig, const ValueList &valListArg) const;
	Value EvalFork(Environment &env, Signal sig, Context &context) const;
	Value EvalMap(Environment &env, Signal sig, Context &context) const;
	Value _EvalMap(Environment &env, Signal sig,
				ResultListComposer *pResultListComposer, Context &context) const;
	bool ShouldGenerateIterator(const ValueList &valListArg) const;
	bool PrepareIteratorsForMap(Signal sig,
				IteratorOwner &iterOwner, const ValueList &valListArg) const;
	virtual bool IsSucceedable(const ICallable *pCallable) const;
	inline FunctionType GetType() const { return _funcType; }
	inline const char *GetTypeName() const { return GetFuncTypeName(_funcType); }
	inline void SetMode(ResultMode rsltMode, MapFlag mapFlag, FlatFlag flatFlag) {
		_rsltMode = rsltMode, _mapFlag = mapFlag, _flatFlag = flatFlag;
	}
	inline MapFlag GetMapFlag() const { return _mapFlag; }
	inline FlatFlag GetFlatFlag() const { return _flatFlag; }
	inline ForkFlag GetForkFlag() const { return _forkFlag; }
	bool CustomDeclare(Environment &env, Signal sig,
			const SymbolSet &attrsAcceptable, ContextExpr &contextExpr);
	void CopyDeclare(const Function &func);
	FunctionCustom *CreateBlockFunc(Environment &env, Signal sig,
						const Expr_Block *pExprBlock, FunctionType funcType) const;
	Declaration *DeclareArg(Environment &env, const Symbol *pSymbol, ValueType valType,
			OccurPattern occurPattern = OCCUR_Once, bool listFlag = false,
			Expr *pExprDefault = NULL);
	inline Declaration *DeclareArg(Environment &env, const char *name, ValueType valType,
			OccurPattern occurPattern = OCCUR_Once, bool listFlag = false,
			Expr *pExprDefault = NULL) {
		return DeclareArg(env, Symbol::Add(name),
								valType, occurPattern, listFlag, pExprDefault);
	}
	inline void DeclareDictArg(const Symbol *pSymbol) { _pSymbolDict = pSymbol; }
	inline void DeclareDictArg(const char *name) { DeclareDictArg(Symbol::Add(name)); }
	inline void DeclareAttr(const Symbol *pSymbol) { _attrsOpt.Insert(pSymbol); }
	inline DeclarationList &GetDeclList() { return _declOwner; }
	inline const DeclarationList &GetDeclList() const { return _declOwner; }
	inline bool IsUnary() const {
		return _declOwner.size() == 1 && !_declOwner.front()->IsVariableLength();
	}
	inline bool IsUnaryable() const { return _declOwner.size() == 1; }
	inline bool IsApplicable(const ValueList &valListArg) const {
		return _declOwner.IsApplicable(valListArg);
	}
	inline void AllowTooManyArgs(bool flag) { _allowTooManyArgsFlag = flag; }
	void DeclareBlock(OccurPattern occurPattern, const Symbol *pSymbol = NULL,
							bool insideScopeFlag = false, bool quoteFlag = false);
	void AssignArgs(Environment &env, Signal sig, const ValueList &valList) const;
	inline void SetHelp(const char *help) { _help = help; }
	inline const char *GetHelp() const { return _help.c_str(); }
	inline bool IsHelpExist() const { return !_help.empty(); }
	String ToString() const;
	void SetError_DivideByZero(Signal sig) const;
	void SetError_InvalidArgumentName(Signal sig, const ExprMap &exprMap) const;
	void SetError_UnsupportedAttr(Signal sig, const SymbolSet &attrs) const;
	void SetError_NotConstructor(Signal sig) const;
	void SetError_NotEnoughArguments(Signal sig) const;
	void SetError_TooManyArguments(Signal sig) const;
	void SetError_ArgumentType(Signal sig,
					const Declaration *pDecl, const Value &value) const;
	void SetError_ArgumentTypeByIndex(Signal sig,
					size_t idxArg, const Value &value) const;
	void SetError_InvalidValue(Signal sig, const Value &value) const;
	void SetError_InvalidValue(Signal sig, const Value &value1, const Value &value2) const;
	void SetError_InvalidValType(Signal sig, const Value &value) const;
	void SetError_InvalidValType(Signal sig, const Value &value1, const Value &value2) const;
	void SetError_InvalidValTypeM(Signal sig, const Value &value1, const Value &value2) const;
	void SetError_ArgumentMustBeList(Signal sig,
					const Declaration *pDecl, const Value &value) const;
	void SetError_InvalidFunctionExpression(Signal sig) const;
	void SetError_InvalidArgument(Signal sig) const;
	void SetError_MathDiffError(Signal sig) const;
	void SetError_MathOptimizeError(Signal sig) const;
	const Function *GetBlockFunction(Environment &env, Signal sig,
												ContextBase &contextBase) const;
	virtual Expr *DiffUnary(Environment &env, Signal sig,
							const Expr *pExprArg, const Symbol *pSymbol) const;
	virtual Expr *DiffBinary(Environment &env, Signal sig,
			const Expr *pExprArg1, const Expr *pExprArg2, const Symbol *pSymbol) const;
	virtual Expr *OptimizeUnary(Environment &env, Signal sig, Expr *pExprOpt) const;
	virtual Expr *OptimizeBinary(Environment &env, Signal sig,
										Expr *pExprOpt1, Expr *pExprOpt2) const;
protected:
	bool PrepareArgsForUnary(Environment &env, Signal sig, const ExprList &exprArgs,
					ValueList &valListArg, Value &valueWithDict) const;
	bool PrepareArgs(Environment &env, Signal sig, const ExprList &exprArgs,
					ValueList &valListArg, Value &valueWithDict) const;
	bool EvalExprArg(Environment &env, Signal sig, ValueList &valListArg,
					const Declaration *pDecl, const Expr *pExprArg, size_t &nElems) const;
	bool ValidateArg(Environment &env, Signal sig,
					const Declaration *pDecl, Value &value, bool listElemFlag) const;
	Value EvalOverride(Signal sig, Context &context, bool &evaluatedFlag) const;
	Value ReturnIterator(Environment &env, Signal sig,
					Context &context, Iterator *pIterator) const;
	Environment *PrepareEnvironment(Environment &env,
										Signal sig, Context &context) const;
private:
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const = 0;
};

//-----------------------------------------------------------------------------
// FunctionCustom
//-----------------------------------------------------------------------------
class FunctionCustom : public Function {
private:
	//Environment _envScope;
	Expr *_pExprBody;
public:
	FunctionCustom(Environment &envScope, const Symbol *pSymbol,
										Expr *pExpr, FunctionType funcType);
	virtual ~FunctionCustom();
	virtual bool IsCustom() const;
	inline const Expr *GetExprBody() const { return _pExprBody; }
	virtual Expr *DiffUnary(Environment &env, Signal sig,
						const Expr *pExprArg, const Symbol *pSymbol) const;
private:
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
};

//-----------------------------------------------------------------------------
// ClassPrototype
//-----------------------------------------------------------------------------
class ClassPrototype : public Function {
private:
	Environment _envScope;
	Expr *_pExprBody;
	Class_Custom *_pClassCustom;
public:
	ClassPrototype(Environment &envScope, const Symbol *pSymbol, Expr *pExpr,
					Class_Custom *pClassCustom, FunctionType funcType);
	virtual ~ClassPrototype();
	virtual Class *GetClassToConstruct() const;
	inline const Expr *GetExprBody() const { return _pExprBody; }
private:
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
};

//-----------------------------------------------------------------------------
// StructPrototype
//-----------------------------------------------------------------------------
class StructPrototype : public Function {
private:
	Class_Custom *_pClassCustom;
public:
	StructPrototype(Environment &env, Class_Custom *pClassCustom);
	virtual ~StructPrototype();
	virtual bool IsStructPrototype() const;
	virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	virtual Class *GetClassToConstruct() const;
};

}

#endif
