#include "Module.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Module
//-----------------------------------------------------------------------------
bool Module::IsModule() const { return true; }

Module::Module(const Module &module) :
	ObjectBase(module), _pSymbol(module._pSymbol),
	_pExprScript((module._pExprScript == NULL)? NULL : module._pExprScript->Clone())
{
}

Module::Module(Environment *pEnvOuter, const Symbol *pSymbol, Expr *pExprScript) :
	ObjectBase(pEnvOuter, ENVTYPE_Module),
	_pSymbol(pSymbol), _pExprScript(pExprScript)
{
	AssignValue(AScript_Symbol(__name__), Value(*this, GetName()), false);
}

Module::~Module()
{
	Expr::Delete(_pExprScript);
}

Module *Module::Clone() const
{
	return new Module(*this);
}

String Module::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<module:";
	str += GetName();
	str += ">";
	return str;
}

void InitModule(Environment &env)
{
	SymbolPool::SetInstance(env.GetGlobal()->_pSymbolPool);
	ValueTypePool::SetInstance(env.GetGlobal()->_pValueTypePool);
}

}
