#==============================================================================
# Makefile for Borland C++
#==============================================================================
# cl /wd4996 /EHsc AScript.cpp Main.cpp

VERSION = build014

SRCS_LIB = \
Common.cpp Algorithm.cpp Codec.cpp Codec_Japanese.cpp Codec_ISO8859.cpp \
Symbol.cpp String.cpp Signal.cpp Formatter.cpp Option.cpp \
File.cpp DateTime.cpp Value.cpp Iterator.cpp Declaration.cpp Environment.cpp \
Function.cpp Object.cpp Module.cpp OAL.cpp \
Object_Function.cpp Object_String.cpp Object_Bytes.cpp \
Object_List.cpp Object_Matrix.cpp Object_Dict.cpp \
Object_File.cpp Object_FileStat.cpp Object_DateTime.cpp Object_TimeDelta.cpp \
Object_Expr.cpp Object_Environment.cpp Object_Error.cpp Object_URI.cpp \
Object_Struct.cpp Object_Custom.cpp Object_Iterator.cpp Object_Semaphore.cpp \
Operator.cpp Expr.cpp Parser.cpp

SVNREPO = https://svn.sourceforge.jp/svnroot/ascript

ZIPSRCFILE_PRE = ascript-$(VERSION)-src
ZIPBINFILE = ascript-$(VERSION)-win32.zip

DISTFILES = \
AScript\DLLs\*.azd AScript\ascript.exe \
AScript\lib\*.az \
AScript\test\test-*.az \
AScript\test\50records-en.csv AScript\test\50records-jp.csv \
AScript\test\temperature.txt \
AScript\test\chars-cp932.txt \
AScript\test\chars-eucjp.txt \
AScript\test\chars-utf8-jp.txt \
AScript\test\testall.bat AScript\test\result\test-*.sample.txt \
AScript\sample\*.az AScript\sample\*.bat

ONIGDIR = onig-5.9.2
EXPATDIR = expat-2.0.1
SQLITEDIR = sqlite-amalgamation-3_6_23_1
SFMTDIR = SFMT-src-1.3.3

OBJS_EXTRA = $(SFMTDIR)\sfmt.obj

LDFLAGS = -q -L$(MAKEDIR)\..\Lib -L$(MAKEDIR)\..\Lib\psdk -lS:10000000

CFLAGS = \
-q -I$(MAKEDIR)\..\Include -w-8057 -w-8004 \
-DVERSION=\"$(VERSION)\" \
-DHAVE_WINDOWS_H \
-I$(ONIGDIR) \
-I$(SFMTDIR) \
-I$(EXPATDIR)\lib \
-I$(SQLITEDIR)

#CFLAGS = $(CFLAGS) -DDEBUG_ASCRIPT

LIBS = $(ONIGDIR)\onig_s.lib
LIBS = $(LIBS) $(EXPATDIR)\bcb5\release\libexpats_mtd.lib

.cpp.obj:
	@bcc32 $(CFLAGS) -c -o$*.obj $<

all: all-stub

SRCS_MODULE_CSV = Module_csv.cpp
!if 0
TGT_MODULE_CSV = ..\DLLs\csv.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_CSV)
$(TGT_MODULE_CSV): $(SRCS_MODULE_CSV:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_csv.obj: Module_csv.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_csv.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_CSV)
!endif

SRCS_MODULE_RE = Module_re.cpp
!if 1
TGT_MODULE_RE = ..\DLLs\re.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_RE)
$(TGT_MODULE_RE): $(SRCS_MODULE_RE:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_re.obj: Module_re.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_re.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_RE)
!endif

SRCS_MODULE_XML = Module_xml.cpp
!if 1
TGT_MODULE_XML = ..\DLLs\xml.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_XML)
$(TGT_MODULE_XML): $(SRCS_MODULE_XML:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_xml.obj: Module_xml.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_xml.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_XML)
!endif

SRCS_MODULE_CANVAS = Module_canvas.cpp
!if 1
TGT_MODULE_CANVAS = ..\DLLs\canvas.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_CANVAS)
$(TGT_MODULE_CANVAS): $(SRCS_MODULE_CANVAS:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_canvas.obj: Module_canvas.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_canvas.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_CANVAS)
!endif

SRCS_MODULE_WIN32OLE = Module_win32ole.cpp
!if 1
TGT_MODULE_WIN32OLE = ..\DLLs\win32ole.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_WIN32OLE)
$(TGT_MODULE_WIN32OLE): $(SRCS_MODULE_WIN32OLE:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_win32ole.obj: Module_win32ole.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_win32ole.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_WIN32OLE)
!endif

SRCS_MODULE_SQLITE = Module_sqlite3.cpp
!if 1
TGT_MODULE_SQLITE = ..\DLLs\sqlite3.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_SQLITE)
$(TGT_MODULE_SQLITE): $(SRCS_MODULE_SQLITE:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA) sqlite-amalgamation-3_6_23_1\sqlite3.obj
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_sqlite3.obj: Module_sqlite3.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_sqlite3.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_SQLITE)
!endif

SRCS_MODULE_SAMPLE = Module_sample.cpp
!if 1
TGT_MODULE_SAMPLE = ..\DLLs\sample.azd
TGT_MODULES = $(TGT_MODULES) $(TGT_MODULE_SAMPLE)
$(TGT_MODULE_SAMPLE): $(SRCS_MODULE_SAMPLE:.cpp=.obj) $(SRCS_LIB:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -tWD -e$@ $** $(LIBS)
Module_sample.obj: Module_sample.cpp
	@bcc32 $(CFLAGS) -DASCRIPT_MODULE_SEPARATED -c Module_sample.cpp
!else
SRCS_INTEGRATED_MODULE = $(SRCS_INTEGRATED_MODULE) $(SRCS_MODULE_SAMPLE)
!endif

SRCS_ASCRIPT = \
Main.cpp \
Module_math.cpp \
Module_builtins.cpp \
Module_os.cpp \
Module_sys.cpp \
Module_time.cpp \
Module_string.cpp \
Module_socket.cpp
TGT_ASCRIPT = ..\ascript.exe
$(TGT_ASCRIPT): $(SRCS_LIB:.cpp=.obj) $(SRCS_ASCRIPT:.cpp=.obj) \
				$(SRCS_INTEGRATED_MODULE:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -e$@ $** $(LIBS)

SRCS_SCRATCH = Scratch.cpp
TGT_SCRATCH = scratch.exe
$(TGT_SCRATCH): $(SRCS_LIB:.cpp=.obj) $(SRCS_SCRATCH:.cpp=.obj) $(OBJS_EXTRA)
	@bcc32 $(LDFLAGS) -e$@ $** $(LIBS)

all-stub: $(TGT_ASCRIPT) $(TGT_SCRATCH) $(TGT_MODULES)

$(SFMTDIR)\sfmt.obj: $(SFMTDIR)\sfmt.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8027 -c -o$@ $**

$(SQLITEDIR)\sqlite3.obj: $(SQLITEDIR)\sqlite3.c
	@bcc32 -I$(MAKEDIR)\..\Include -q -w-8004 -w-8065 -c -o$@ $**

clean:
	@del $(TGT_ASCRIPT) $(TGT_SCRATCH) $(TGT_MODULES) ..\*.tds ..\DLLs\*.tds *.obj $(OBJS_EXTRA)

listtag:
	svn ls $(SVNREPO)/tags

deltag:
	svn del $(SVNREPO)/tags/$(VERSION) -m ""

maketag:
	svn copy $(SVNREPO)/trunk $(SVNREPO)/tags/$(VERSION) -m "version $(VERSION) release"

distsrc:
	if exist ascript-$(VERSION) rmdir /s /q ascript-$(VERSION)
	svn export $(SVNREPO)/tags/$(VERSION) ascript-$(VERSION)
	7z a $(ZIPSRCFILE_PRE).tar ascript-$(VERSION)
	7z a $(ZIPSRCFILE_PRE).tar.gz $(ZIPSRCFILE_PRE).tar
	del $(ZIPSRCFILE_PRE).tar
	move /Y $(ZIPSRCFILE_PRE).tar.gz ..\..
	rmdir /s /q ascript-$(VERSION)

distbin:
	cd ..\..
	del $(ZIPBINFILE)
	7z a $(ZIPBINFILE) $(DISTFILES)
