#include "Symbol.h"
#include "String.h"
#include "Value.h"
#include "Function.h"

extern "C" {
#include "../extra/SFMT-src-1.3.3/SFMT.h"
}

//-----------------------------------------------------------------------------
// Heap access functions
//-----------------------------------------------------------------------------
#if defined(__BORLANDC__)
// malloc() and free() don't work correctly when they're used across
// Windows' DLL boundary. see KB190799 in MSDN.
DLLDECLARE void *operator new (size_t bytes)
{
	return ::LocalAlloc(LMEM_FIXED, bytes);
}

DLLDECLARE void operator delete (void *p)
{
	::LocalFree(p);
}
#endif

namespace AScript {

const int MAX_STACK_LEVEL = 20000;

bool IsBigEndian()
{
	long num = 0x12345678;
	return *reinterpret_cast<char *>(&num) == 0x12;
}

const char *GetVersion()
{
	return ASCRIPT_VERSION;
}

const char *GetOpening()
{
	static char buff[80];
#if defined(_MSC_VER)
	::sprintf(buff, "AScript %s [MSC v.%d] copyright (c) 2010- Dan-san", ASCRIPT_VERSION, _MSC_VER);
#elif defined(__BORLANDC__)
	::sprintf(buff, "AScript %s [BCC v.%x] copyright (c) 2010- Dan-san", ASCRIPT_VERSION, __BORLANDC__);
#elif defined(__GNUC__) && defined(__GNUC_MINOR__)
	::sprintf(buff, "AScript %s [GNUC v.%d.%d] copyright (c) 2010- Dan-san", ASCRIPT_VERSION, __GNUC__, __GNUC_MINOR__);
#else
	::sprintf(buff, "AScript %s copyright (c) 2010- Dan-san", ASCRIPT_VERSION);
#endif
	return buff;
}

//-----------------------------------------------------------------------------
// RandomGenerator
//-----------------------------------------------------------------------------
void RandomGenerator::Initialize(unsigned long seed)
{
	::init_gen_rand(seed);	// initialize random generator SFMT
}

double RandomGenerator::Real2()
{
	return ::genrand_real2();
}

int RandomGenerator::operator()(int n)
{
	return static_cast<int>(::genrand_real2() * n);
}


}
