#ifndef __COMMON_H__
#define __COMMON_H__

#if !defined(ASCRIPT_VERSION)
#define ASCRIPT_VERSION "build017"
#endif

#if defined(__BORLANDC__)
#define HAVE_WINDOWS_H
#endif

#if defined(_MSC_VER)
#define HAVE_WINDOWS_H
#pragma warning(disable:4251)
#pragma warning(disable:4275)
#pragma warning(disable:4355)
#pragma warning(disable:4996)
#endif

#if defined(HAVE_WINDOWS_H)
#include <windows.h>
#include <direct.h>		// getcwd()
#define DLLIMPORT __declspec(dllimport)
#define DLLEXPORT __declspec(dllexport)
#if defined(ASCRIPT_EXPORTS)
#define DLLDECLARE __declspec(dllexport)
#else
#define DLLDECLARE __declspec(dllimport)
#endif
typedef __int64 int64;
typedef unsigned __int64 uint64;
#define strcasecmp stricmp
#elif defined(HAVE_CONFIG_H)
#include "config.h"
#define DLLIMPORT
#define DLLEXPORT
#define DLLDECLARE
typedef long long int64;
typedef unsigned long long uint64;
#endif

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <complex>
#include <vector>
#include <deque>
#include <list>
#include <map>
#include <set>
#include <memory>
#include <algorithm>

#define NUMBEROF(x) (sizeof(x) / sizeof(x[0]))

#define ChooseMin(a, b) (((a) < (b))? (a) : (b))

#define foreach(T, i, c) for (T::iterator i = (c).begin(); i != (c).end(); i++)
#define foreach_const(T, i, c) for (T::const_iterator i = (c).begin(); i != (c).end(); i++)
#define foreach_reverse(T, i, c) for (T::reverse_iterator i = (c).rbegin(); i != (c).rend(); i++)
#define foreach_const_reverse(T, i, c) for (T::const_reverse_iterator i = (c).rbegin(); i != (c).rend(); i++)

#ifdef DEBUG_ASCRIPT
#define DBG(x) x
#define DBGPARSER(x) x
#define ASSUME(env, x) if (!(x)) { env.Error(__FILE__, __LINE__, #x); }
#else
#define DBG(x)
#define DBGPARSER(x)
#define ASSUME(env, x) if (!(x)) { env.Error(__FILE__, __LINE__, #x); }
#endif

#define ERROREND(env, str) (env).Error(__FILE__, __LINE__, (str));

namespace AScript {

extern const int MAX_STACK_LEVEL;

DLLDECLARE bool IsBigEndian();
DLLDECLARE const char *GetVersion();
DLLDECLARE const char *GetOpening();

//-----------------------------------------------------------------------------
// Simple type declarations
//-----------------------------------------------------------------------------
typedef double Number;
typedef std::complex<Number> Complex;

typedef std::vector<Number> NumberList;
typedef std::vector<Complex> ComplexList;

typedef std::basic_string<char> String;
typedef std::basic_string<char> Bytes;

typedef std::deque<String> StringDeque;

//-----------------------------------------------------------------------------
// OccurPattern
//-----------------------------------------------------------------------------
enum OccurPattern {
	OCCUR_Invalid,
	OCCUR_Zero,			// (none)
	OCCUR_Once,			// 1
	OCCUR_ZeroOrOnce,	// ?
	OCCUR_ZeroOrMore,	// *
	OCCUR_OnceOrMore,	// +
};

//-----------------------------------------------------------------------------
// RandomGenerator
//-----------------------------------------------------------------------------
class RandomGenerator {
public:
	static void Initialize(unsigned long seed);
	static double Real2();
	int operator()(int n);
};

}
#endif
