#ifndef __OBJECT_DICT_H__
#define __OBJECT_DICT_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Dict / Object_Dict
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Dict : public Class {
public:
	Class_Dict(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Dict : public Object {
public:
	class IteratorKeys : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorKeys(Object_Dict *pObj);
		virtual ~IteratorKeys();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class IteratorValues : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorValues(Object_Dict *pObj);
		virtual ~IteratorValues();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class IteratorItems : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorItems(Object_Dict *pObj);
		virtual ~IteratorItems();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
	class IteratorGet : public Iterator {
	private:
		Object_Dict *_pObj;
		Iterator *_pIteratorKey;
		Value _valDefault;
		bool _raiseFlag;
		bool _setDefaultFlag;
	public:
		IteratorGet(Object_Dict *pObj, Iterator *pIteratorKey,
					const Value &valDefault, bool raiseFlag, bool setDefaultFlag);
		virtual ~IteratorGet();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_Dict *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Dict *>(context.GetSelfObj());
	}
private:
	ValueDict _valDict;
public:
	inline Object_Dict(Class *pClass) : Object(pClass) {}
	inline Object_Dict(const Object_Dict &obj) :
								Object(obj), _valDict(obj._valDict) {}
	virtual bool IsDict() const;
	virtual Object *Clone() const;
	inline ValueDict &GetDict() { return _valDict; }
	inline const ValueDict &GetDict() const { return _valDict; }
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	const Value *Find(Signal sig, const Value &valueIdx) const;
	static void SetError_KeyNotFound(Signal sig, const Value &valueIdx);
};

}

#endif
